/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.yaml;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.yaml.config.ConfigYAML;
import com.liferay.portal.vulcan.yaml.config.Security;
import com.liferay.portal.vulcan.yaml.exception.InvalidYAMLException;
import com.liferay.portal.vulcan.yaml.openapi.Items;
import com.liferay.portal.vulcan.yaml.openapi.OpenAPIYAML;
import com.liferay.portal.vulcan.yaml.openapi.Parameter;
import com.liferay.portal.vulcan.yaml.openapi.PathItem;
import com.liferay.portal.vulcan.yaml.openapi.Schema;
import com.liferay.portal.vulcan.yaml.openapi.SchemaDefinition;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.representer.Representer;

public class YAMLUtil {
    private static final String[] _LIFERAY_PROPERTIES = new String[]{"x-field-definition", "x-operation-definition", "x-schema-definition"};
    private static final Yaml _YAML_CONFIG;
    private static final Yaml _YAML_OPEN_API;

    public static ConfigYAML loadConfigYAML(String yamlString) {
        try {
            return (ConfigYAML)_YAML_CONFIG.loadAs(yamlString, ConfigYAML.class);
        }
        catch (MarkedYAMLException markedYAMLException) {
            throw new InvalidYAMLException((Exception)((Object)markedYAMLException));
        }
    }

    public static OpenAPIYAML loadOpenAPIYAML(String yamlString) {
        try {
            return (OpenAPIYAML)_YAML_OPEN_API.loadAs(yamlString, OpenAPIYAML.class);
        }
        catch (MarkedYAMLException markedYAMLException) {
            throw new InvalidYAMLException((Exception)((Object)markedYAMLException));
        }
    }

    static {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        Constructor configYAMLConstructor = new Constructor(ConfigYAML.class, loaderOptions);
        TypeDescription securityTypeDescription = new TypeDescription(Security.class);
        securityTypeDescription.substituteProperty("oAuth2", String.class, "getOAuth2", "setOAuth2", new Class[0]);
        configYAMLConstructor.addTypeDescription(securityTypeDescription);
        Representer representer = new Representer(new DumperOptions()){
            {
                this.setPropertyUtils(new PropertyUtils(){
                    {
                        this.setSkipMissingProperties(true);
                    }

                    public Property getProperty(Class<? extends Object> type, String name) {
                        if (ArrayUtil.contains((String[])_LIFERAY_PROPERTIES, (String)name, (boolean)false)) {
                            name = CamelCaseUtil.toCamelCase((String)StringUtil.removeFirst((String)name, (String)"x-"));
                        }
                        return super.getProperty(type, name);
                    }
                });
            }
        };
        _YAML_CONFIG = new Yaml((BaseConstructor)configYAMLConstructor, representer, new DumperOptions(), loaderOptions);
        Constructor openAPIYAMLConstructor = new Constructor(OpenAPIYAML.class, loaderOptions);
        TypeDescription itemsTypeDescription = new TypeDescription(Items.class);
        itemsTypeDescription.substituteProperty("$ref", String.class, "getReference", "setReference", new Class[0]);
        itemsTypeDescription.substituteProperty("additionalProperties", Schema.class, "getAdditionalPropertySchema", "setAdditionalPropertySchema", new Class[0]);
        itemsTypeDescription.substituteProperty("properties", Map.class, "getPropertySchemas", "setPropertySchemas", new Class[0]);
        itemsTypeDescription.addPropertyParameters("properties", new Class[]{String.class, Schema.class});
        openAPIYAMLConstructor.addTypeDescription(itemsTypeDescription);
        TypeDescription openAPIYAMLTypeDescription = new TypeDescription(OpenAPIYAML.class);
        openAPIYAMLTypeDescription.substituteProperty("paths", Map.class, "getPathItems", "setPathItems", new Class[0]);
        openAPIYAMLTypeDescription.addPropertyParameters("paths", new Class[]{String.class, PathItem.class});
        openAPIYAMLConstructor.addTypeDescription(openAPIYAMLTypeDescription);
        TypeDescription parameterTypeDescription = new TypeDescription(Parameter.class);
        parameterTypeDescription.substituteProperty("$ref", String.class, "getReference", "setReference", new Class[0]);
        openAPIYAMLConstructor.addTypeDescription(parameterTypeDescription);
        TypeDescription schemaTypeDescription = new TypeDescription(Schema.class);
        schemaTypeDescription.substituteProperty("$ref", String.class, "getReference", "setReference", new Class[0]);
        schemaTypeDescription.substituteProperty("additionalProperties", Schema.class, "getAdditionalPropertySchema", "setAdditionalPropertySchema", new Class[0]);
        schemaTypeDescription.substituteProperty("allOf", List.class, "getAllOfSchemas", "setAllOfSchemas", new Class[0]);
        schemaTypeDescription.addPropertyParameters("allOf", new Class[]{Schema.class});
        schemaTypeDescription.substituteProperty("anyOf", List.class, "getAnyOfSchemas", "setAnyOfSchemas", new Class[0]);
        schemaTypeDescription.addPropertyParameters("anyOf", new Class[]{Schema.class});
        schemaTypeDescription.substituteProperty("enum", List.class, "getEnumValues", "setEnumValues", new Class[0]);
        schemaTypeDescription.addPropertyParameters("enum", new Class[]{String.class});
        schemaTypeDescription.substituteProperty("oneOf", List.class, "getOneOfSchemas", "setOneOfSchemas", new Class[0]);
        schemaTypeDescription.addPropertyParameters("oneOf", new Class[]{Schema.class});
        schemaTypeDescription.substituteProperty("properties", Map.class, "getPropertySchemas", "setPropertySchemas", new Class[0]);
        schemaTypeDescription.addPropertyParameters("properties", new Class[]{String.class, Schema.class});
        schemaTypeDescription.substituteProperty("required", List.class, "getRequiredPropertySchemaNames", "setRequiredPropertySchemaNames", new Class[0]);
        schemaTypeDescription.addPropertyParameters("required", new Class[]{String.class});
        schemaTypeDescription.substituteProperty("xSchemaDefinition", SchemaDefinition.class, "getSchemaDefinition", "setSchemaDefinition", new Class[0]);
        openAPIYAMLConstructor.addTypeDescription(schemaTypeDescription);
        _YAML_OPEN_API = new Yaml((BaseConstructor)openAPIYAMLConstructor, representer, new DumperOptions(), loaderOptions);
    }
}

