/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.fields;

import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.fields.NestedFieldsContext;
import com.liferay.portal.vulcan.fields.NestedFieldsContextThreadLocal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NestedFieldsSupplier<T> {
    public static void addFieldName(String fieldName) {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (nestedFieldsContext != null) {
            nestedFieldsContext.addFieldName(fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T supply(String fieldName, UnsafeFunction<String, T, Exception> unsafeFunction) throws Exception {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (!NestedFieldsSupplier._mustProcessNestedFields(nestedFieldsContext)) {
            return null;
        }
        List<String> fieldNames = nestedFieldsContext.getFieldNames();
        if (!fieldNames.contains(fieldName)) {
            return null;
        }
        nestedFieldsContext.incrementCurrentDepth();
        try {
            Object object = unsafeFunction.apply((Object)fieldName);
            return (T)object;
        }
        finally {
            nestedFieldsContext.decrementCurrentDepth();
        }
    }

    public static <T> Map<String, T> supply(UnsafeFunction<String, T, Exception> unsafeFunction) throws Exception {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (!NestedFieldsSupplier._mustProcessNestedFields(nestedFieldsContext)) {
            return null;
        }
        HashMap<String, Object> nestedFieldValues = new HashMap<String, Object>();
        nestedFieldsContext.incrementCurrentDepth();
        for (String fieldName : nestedFieldsContext.getFieldNames()) {
            Object value = unsafeFunction.apply((Object)fieldName);
            if (value == null) continue;
            nestedFieldValues.put(fieldName, value);
        }
        nestedFieldsContext.decrementCurrentDepth();
        return nestedFieldValues;
    }

    private static boolean _mustProcessNestedFields(NestedFieldsContext nestedFieldsContext) {
        return nestedFieldsContext != null && nestedFieldsContext.getCurrentDepth() < nestedFieldsContext.getDepth() && ListUtil.isNotEmpty(nestedFieldsContext.getFieldNames());
    }
}

