/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.accept.language;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotFoundException;

public class AcceptLanguageImpl
implements AcceptLanguage {
    private final HttpServletRequest _httpServletRequest;
    private final Language _language;
    private final Portal _portal;

    public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Language language, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._language = language;
        this._portal = portal;
    }

    public List<Locale> getLocales() {
        String acceptLanguage = this._httpServletRequest.getHeader("Accept-Language");
        if (Validator.isNull((String)acceptLanguage)) {
            return Collections.emptyList();
        }
        if (acceptLanguage.equals("zh-Hans-CN")) {
            acceptLanguage = "zh-CN";
        } else if (acceptLanguage.equals("zh-Hant-TW")) {
            acceptLanguage = "zh-TW";
        }
        try {
            Company company = this._portal.getCompany(this._httpServletRequest);
            Set companyAvailableLocales = this._language.getCompanyAvailableLocales(company.getCompanyId());
            List locales = Locale.filter(Locale.LanguageRange.parse(acceptLanguage), companyAvailableLocales);
            locales = TransformUtil.transform(locales, locale -> {
                for (Locale availableLocale : companyAvailableLocales) {
                    if (!LocaleUtil.equals((Locale)locale, (Locale)availableLocale)) continue;
                    return availableLocale;
                }
                return null;
            });
            if (ListUtil.isEmpty((List)locales) && !Objects.equals(this._httpServletRequest.getMethod(), "GET")) {
                throw new NotAcceptableException("No locales match the accepted languages: " + acceptLanguage);
            }
            return locales;
        }
        catch (PortalException portalException) {
            throw new InternalServerErrorException("Unable to get locales: " + portalException.getMessage(), (Throwable)portalException);
        }
    }

    public String getPreferredLanguageId() {
        return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
    }

    public Locale getPreferredLocale() {
        List<Locale> locales = this.getLocales();
        if (ListUtil.isNotEmpty(locales)) {
            return locales.get(0);
        }
        try {
            User user = this._portal.initUser(this._httpServletRequest);
            return user.getLocale();
        }
        catch (NoSuchUserException noSuchUserException) {
            throw new NotFoundException("Unable to get preferred locale from nonexistent user", (Throwable)noSuchUserException);
        }
        catch (Exception exception) {
            throw new InternalServerErrorException("Unable to get preferred locale: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean isAcceptAllLanguages() {
        String acceptAllLanguages = this._httpServletRequest.getHeader("X-Liferay-Accept-All-Languages");
        if (acceptAllLanguages != null) {
            return GetterUtil.getBoolean((String)acceptAllLanguages);
        }
        return GetterUtil.getBoolean((String)this._httpServletRequest.getHeader("X-Accept-All-Languages"));
    }
}

