/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.batch.engine;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegateRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={VulcanBatchEngineTaskItemDelegateRegistry.class})
public class VulcanBatchEngineTaskItemDelegateRegistryImpl
implements VulcanBatchEngineTaskItemDelegateRegistry {
    private final Map<String, Boolean> _batchPlannerExportEnableds = new HashMap<String, Boolean>();
    private final Map<String, Boolean> _batchPlannerImportEnableds = new HashMap<String, Boolean>();
    private final Map<Long, Map<String, Boolean>> _companyScopedBatchPlannerExportEnabledsMap = new HashMap<Long, Map<String, Boolean>>();
    private final Map<Long, Map<String, Boolean>> _companyScopedBatchPlannerImportEnabledsMap = new HashMap<Long, Map<String, Boolean>>();
    private final Map<Long, Map<String, VulcanBatchEngineTaskItemDelegate<?>>> _companyScopedVulcanBatchEngineTaskItemDelegatesMap = new HashMap();
    private ServiceTracker<?, ?> _serviceTracker;
    private final Map<String, VulcanBatchEngineTaskItemDelegate<?>> _vulcanBatchEngineTaskItemDelegates = new HashMap();

    public Set<String> getEntityClassNames(long companyId) {
        HashSet<String> entityClassNames = new HashSet<String>();
        entityClassNames.addAll(this._vulcanBatchEngineTaskItemDelegates.keySet());
        Map<String, VulcanBatchEngineTaskItemDelegate<?>> companyVulcanBatchEngineTaskItemDelegates = this._companyScopedVulcanBatchEngineTaskItemDelegatesMap.get(companyId);
        if (companyVulcanBatchEngineTaskItemDelegates != null) {
            entityClassNames.addAll(companyVulcanBatchEngineTaskItemDelegates.keySet());
        }
        return entityClassNames;
    }

    public VulcanBatchEngineTaskItemDelegate<?> getVulcanBatchEngineTaskItemDelegate(long companyId, String entityClassName) {
        VulcanBatchEngineTaskItemDelegate<?> vulcanBatchEngineTaskItemDelegate = this._vulcanBatchEngineTaskItemDelegates.get(entityClassName);
        if (vulcanBatchEngineTaskItemDelegate != null) {
            return vulcanBatchEngineTaskItemDelegate;
        }
        Map<String, VulcanBatchEngineTaskItemDelegate<?>> companyVulcanBatchEngineTaskItemDelegates = this._companyScopedVulcanBatchEngineTaskItemDelegatesMap.get(companyId);
        if (companyVulcanBatchEngineTaskItemDelegates != null) {
            return companyVulcanBatchEngineTaskItemDelegates.get(entityClassName);
        }
        return null;
    }

    public boolean isBatchPlannerExportEnabled(long companyId, String entityClassName) {
        Boolean batchPlannerExportEnabled = this._batchPlannerExportEnableds.get(entityClassName);
        if (batchPlannerExportEnabled != null) {
            return batchPlannerExportEnabled;
        }
        Map<String, Boolean> companyBatchPlannerExportEnableds = this._companyScopedBatchPlannerExportEnabledsMap.get(companyId);
        return companyBatchPlannerExportEnableds.get(entityClassName);
    }

    public boolean isBatchPlannerImportEnabled(long companyId, String entityClassName) {
        Boolean batchPlannerImportEnabled = this._batchPlannerImportEnableds.get(entityClassName);
        if (batchPlannerImportEnabled != null) {
            return batchPlannerImportEnabled;
        }
        Map<String, Boolean> companyBatchPlannerImportEnableds = this._companyScopedBatchPlannerImportEnabledsMap.get(companyId);
        return companyBatchPlannerImportEnableds.get(entityClassName);
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        Filter filter = bundleContext.createFilter("(batch.engine.task.item.delegate=true)");
        this._serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<VulcanBatchEngineTaskItemDelegate<?>, VulcanBatchEngineTaskItemDelegate<?>> {
        private final BundleContext _bundleContext;

        public VulcanBatchEngineTaskItemDelegate<?> addingService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference) {
            boolean batchPlannerExportEnabled = GetterUtil.getBoolean((Object)serviceReference.getProperty("batch.planner.export.enabled"));
            boolean batchPlannerImportEnabled = GetterUtil.getBoolean((Object)serviceReference.getProperty("batch.planner.import.enabled"));
            List<String> companyIdStrings = this._getCompanyIdStrings(serviceReference);
            String entityClassName = (String)serviceReference.getProperty("batch.engine.entity.class.name");
            VulcanBatchEngineTaskItemDelegate vulcanBatchEngineTaskItemDelegate = (VulcanBatchEngineTaskItemDelegate)this._bundleContext.getService(serviceReference);
            if (companyIdStrings == null) {
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerExportEnableds.put(entityClassName, batchPlannerExportEnabled);
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerImportEnableds.put(entityClassName, batchPlannerImportEnabled);
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._vulcanBatchEngineTaskItemDelegates.put(entityClassName, vulcanBatchEngineTaskItemDelegate);
            } else {
                for (String companyIdString : companyIdStrings) {
                    long companyId = GetterUtil.getLong((String)companyIdString);
                    VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerExportEnabledsMap.compute(companyId, (key, batchPlannerExportEnabledMap) -> {
                        if (batchPlannerExportEnabledMap == null) {
                            batchPlannerExportEnabledMap = new HashMap<String, Boolean>();
                        }
                        batchPlannerExportEnabledMap.put(entityClassName, batchPlannerExportEnabled);
                        return batchPlannerExportEnabledMap;
                    });
                    VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerImportEnabledsMap.compute(companyId, (key, batchPlannerImportEnabledMap) -> {
                        if (batchPlannerImportEnabledMap == null) {
                            batchPlannerImportEnabledMap = new HashMap<String, Boolean>();
                        }
                        batchPlannerImportEnabledMap.put(entityClassName, batchPlannerImportEnabled);
                        return batchPlannerImportEnabledMap;
                    });
                    VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedVulcanBatchEngineTaskItemDelegatesMap.compute(companyId, (key, vulcanBatchEngineTaskItemDelegateMap) -> {
                        if (vulcanBatchEngineTaskItemDelegateMap == null) {
                            vulcanBatchEngineTaskItemDelegateMap = new HashMap<String, VulcanBatchEngineTaskItemDelegate>();
                        }
                        vulcanBatchEngineTaskItemDelegateMap.put(entityClassName, vulcanBatchEngineTaskItemDelegate);
                        return vulcanBatchEngineTaskItemDelegateMap;
                    });
                }
            }
            return vulcanBatchEngineTaskItemDelegate;
        }

        public void modifiedService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference, VulcanBatchEngineTaskItemDelegate<?> vulcanBatchEngineTaskItemDelegate) {
            List<String> companyIdStrings = this._getCompanyIdStrings(serviceReference);
            if (companyIdStrings == null) {
                return;
            }
            String entityClassName = (String)serviceReference.getProperty("batch.engine.entity.class.name");
            for (Map.Entry<Long, Map<String, Boolean>> entry : VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerExportEnabledsMap.entrySet()) {
                if (companyIdStrings.contains(String.valueOf(entry.getKey()))) continue;
                Map<String, Boolean> companyBatchPlannerExportEnableds = entry.getValue();
                companyBatchPlannerExportEnableds.remove(entityClassName);
            }
            for (Map.Entry<Long, Map<String, Boolean>> entry : VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerImportEnabledsMap.entrySet()) {
                if (companyIdStrings.contains(String.valueOf(entry.getKey()))) continue;
                Map<String, Boolean> companyBatchPlannerImportEnableds = entry.getValue();
                companyBatchPlannerImportEnableds.remove(entityClassName);
            }
            for (Map.Entry<Long, Map<String, Boolean>> entry : VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedVulcanBatchEngineTaskItemDelegatesMap.entrySet()) {
                if (companyIdStrings.contains(String.valueOf(entry.getKey()))) continue;
                Map<String, Boolean> companyVulcanBatchEngineTaskItemDelegates = entry.getValue();
                companyVulcanBatchEngineTaskItemDelegates.remove(entityClassName);
            }
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference, VulcanBatchEngineTaskItemDelegate<?> vulcanBatchEngineTaskItemDelegate) {
            List<String> companyIdStrings = this._getCompanyIdStrings(serviceReference);
            String entityClassName = (String)serviceReference.getProperty("batch.engine.entity.class.name");
            if (companyIdStrings == null) {
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerExportEnableds.remove(entityClassName);
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerImportEnableds.remove(entityClassName);
                VulcanBatchEngineTaskItemDelegateRegistryImpl.this._vulcanBatchEngineTaskItemDelegates.remove(entityClassName);
            } else {
                for (String companyIdString : companyIdStrings) {
                    long companyId = GetterUtil.getLong((String)companyIdString);
                    Map<String, Boolean> companyBatchPlannerExportEnableds = VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerExportEnabledsMap.get(companyId);
                    companyBatchPlannerExportEnableds.remove(entityClassName);
                    Map<String, Boolean> companyBatchPlannerImportEnableds = VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedBatchPlannerImportEnabledsMap.get(companyId);
                    companyBatchPlannerImportEnableds.remove(entityClassName);
                    Map<String, VulcanBatchEngineTaskItemDelegate<?>> companyVulcanBatchEngineTaskItemDelegates = VulcanBatchEngineTaskItemDelegateRegistryImpl.this._companyScopedVulcanBatchEngineTaskItemDelegatesMap.get(companyId);
                    companyVulcanBatchEngineTaskItemDelegates.remove(entityClassName);
                }
            }
        }

        private VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        private List<String> _getCompanyIdStrings(ServiceReference<?> serviceReference) {
            Object companyIdObject = serviceReference.getProperty("companyId");
            if (companyIdObject == null) {
                return null;
            }
            if (companyIdObject instanceof List) {
                return (List)companyIdObject;
            }
            return Collections.singletonList(String.valueOf(companyIdObject));
        }
    }
}

