/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.batch.engine.action;

import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.action.ItemReaderPostAction;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.extension.ExtensionProviderRegistry;
import com.liferay.portal.vulcan.extension.util.ExtensionUtil;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ItemReaderPostAction.class})
public class EntityExtensionItemReaderPostAction
implements ItemReaderPostAction {
    @Reference
    private ExtensionProviderRegistry _extensionProviderRegistry;

    public void run(BatchEngineImportTask batchEngineImportTask, Map<String, Serializable> extendedProperties, Object item) throws ReflectiveOperationException {
        EntityExtensionHandler entityExtensionHandler = ExtensionUtil.getEntityExtensionHandler((String)batchEngineImportTask.getClassName(), (long)batchEngineImportTask.getCompanyId(), (ExtensionProviderRegistry)this._extensionProviderRegistry);
        if (entityExtensionHandler == null) {
            if (MapUtil.isNotEmpty(extendedProperties)) {
                throw new NoSuchFieldException(String.valueOf(extendedProperties.keySet()));
            }
            return;
        }
        try {
            entityExtensionHandler.validate(batchEngineImportTask.getCompanyId(), extendedProperties, this._isPartialUpdate(batchEngineImportTask));
            ExtensionUtil.setExtendedProperties((Object)item, extendedProperties);
        }
        catch (Exception exception) {
            throw new ReflectiveOperationException(exception);
        }
    }

    private boolean _isPartialUpdate(BatchEngineImportTask batchEngineImportTask) {
        BatchEngineTaskOperation batchEngineTaskOperation = BatchEngineTaskOperation.valueOf((String)batchEngineImportTask.getOperation());
        String createStrategy = batchEngineImportTask.getParameterValue("createStrategy");
        String updateStrategy = batchEngineImportTask.getParameterValue("updateStrategy");
        if (batchEngineTaskOperation == BatchEngineTaskOperation.CREATE && StringUtil.equals((String)createStrategy, (String)"UPSERT") && StringUtil.equals((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            return true;
        }
        return batchEngineTaskOperation == BatchEngineTaskOperation.UPDATE && StringUtil.equals((String)updateStrategy, (String)"PARTIAL_UPDATE");
    }
}

