/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.dto.converter;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DTOConverterRegistry.class})
public class DTOConverterRegistryImpl
implements DTOConverterRegistry {
    private ServiceTrackerMap<String, DTOConverter<?, ?>> _serviceTrackerMap;

    public Set<String> getDTOClassNames() {
        return this._serviceTrackerMap.keySet();
    }

    public DTOConverter<?, ?> getDTOConverter(String dtoClassName) {
        return (DTOConverter)this._serviceTrackerMap.getService((Object)dtoClassName);
    }

    public DTOConverter<?, ?> getDTOConverter(String applicationName, String dtoClassName, String version) {
        return (DTOConverter)this._serviceTrackerMap.getService((Object)this._getKey(applicationName, dtoClassName, version));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DTOConverter.class, (String)"(dto.class.name=*)", (serviceReference, emitter) -> {
            String dtoClassName = (String)serviceReference.getProperty("dto.class.name");
            emitter.emit((Object)dtoClassName);
            String applicationName = (String)serviceReference.getProperty("application.name");
            String version = (String)serviceReference.getProperty("version");
            if (!Validator.isBlank((String)applicationName) && !Validator.isBlank((String)version)) {
                emitter.emit((Object)this._getKey(applicationName, dtoClassName, version));
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getKey(String applicationName, String dtoClassName, String version) {
        return StringBundler.concat((String[])new String[]{applicationName, "#", dtoClassName, "#", version});
    }
}

