/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.dto.converter;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={DTOMapper.class})
public class DTOMapperImpl
implements DTOMapper {
    private ServiceTrackerMap<String, String> _serviceTrackerMap;

    public String toInternalDTOClassName(String externalDTOClassName) {
        return (String)this._serviceTrackerMap.getService((Object)externalDTOClassName);
    }

    @Activate
    protected void activate(final BundleContext bundleContext) throws Exception {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DTOConverter.class, null, (serviceReference, emitter) -> {
            String externalDTOClassName = (String)serviceReference.getProperty("external.dto.class.name");
            if (externalDTOClassName == null) {
                DTOConverter dtoConverter = (DTOConverter)bundleContext.getService(serviceReference);
                externalDTOClassName = this._getDTOConverterGenericType(dtoConverter, 1);
                bundleContext.ungetService(serviceReference);
            }
            if (externalDTOClassName != null) {
                emitter.emit((Object)externalDTOClassName);
            }
        }, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DTOConverter<?, ?>, String>(){

            public String addingService(ServiceReference<DTOConverter<?, ?>> serviceReference) {
                String internalDTOClassName = (String)serviceReference.getProperty("dto.class.name");
                if (internalDTOClassName == null) {
                    DTOConverter dtoConverter = (DTOConverter)bundleContext.getService(serviceReference);
                    internalDTOClassName = DTOMapperImpl.this._getDTOConverterGenericType(dtoConverter, 0);
                    bundleContext.ungetService(serviceReference);
                }
                return internalDTOClassName;
            }

            public void modifiedService(ServiceReference<DTOConverter<?, ?>> serviceReference, String internalDTOClassName) {
            }

            public void removedService(ServiceReference<DTOConverter<?, ?>> serviceReference, String internalDTOClassName) {
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getDTOConverterGenericType(DTOConverter<?, ?> dtoConverter, int genericTypeIndex) {
        Type[] genericInterfaceTypes;
        Class<?> dtoConverterClass = dtoConverter.getClass();
        for (Type genericInterfaceType : genericInterfaceTypes = dtoConverterClass.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(genericInterfaceType instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericInterfaceType).getRawType() != DTOConverter.class) continue;
            Type[] genericTypes = parameterizedType.getActualTypeArguments();
            Class resourceGenericType = (Class)genericTypes[genericTypeIndex];
            return resourceGenericType.getName();
        }
        return null;
    }
}

