/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.data.fetcher;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContext;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContextValidator;
import graphql.kickstart.servlet.context.GraphQLServletContext;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseDataFetcher
implements DataFetcher<Object> {
    private static final Log _log = LogFactoryUtil.getLog(BaseDataFetcher.class);
    private final GraphQLRequestContext _graphQLRequestContext;
    private final ServiceTrackerList<GraphQLRequestContextValidator> _graphQLRequestContextValidators;

    public BaseDataFetcher(GraphQLRequestContext graphQLRequestContext, ServiceTrackerList<GraphQLRequestContextValidator> graphQLRequestContextValidators) {
        this._graphQLRequestContext = graphQLRequestContext;
        this._graphQLRequestContextValidators = graphQLRequestContextValidators;
    }

    public final Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
        try {
            for (GraphQLRequestContextValidator graphQLRequestContextValidator : this._graphQLRequestContextValidators) {
                graphQLRequestContextValidator.validate(this._graphQLRequestContext);
            }
            return this.get(dataFetchingEnvironment, this._getHttpServletRequest(dataFetchingEnvironment), this._getHttpServletResponse(dataFetchingEnvironment));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw exception;
        }
    }

    public abstract Object get(DataFetchingEnvironment var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;

    private HttpServletRequest _getHttpServletRequest(DataFetchingEnvironment dataFetchingEnvironment) {
        GraphQLServletContext graphQLServletContext = (GraphQLServletContext)dataFetchingEnvironment.getContext();
        return graphQLServletContext.getHttpServletRequest();
    }

    private HttpServletResponse _getHttpServletResponse(DataFetchingEnvironment dataFetchingEnvironment) {
        GraphQLServletContext graphQLServletContext = (GraphQLServletContext)dataFetchingEnvironment.getContext();
        return graphQLServletContext.getHttpServletResponse();
    }
}

