/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.data.fetcher;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOProperty;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContext;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContextValidator;
import com.liferay.portal.vulcan.internal.graphql.data.fetcher.BaseDataFetcher;
import com.liferay.portal.vulcan.internal.graphql.data.processor.GraphQLDTOContributorDataFetchingProcessor;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class GraphQLDTOContributorDataFetcher
extends BaseDataFetcher {
    private static final Map<GraphQLDTOContributor.Operation, String> _httpMethods = HashMapBuilder.put((Object)GraphQLDTOContributor.Operation.CREATE, (Object)"POST").put((Object)GraphQLDTOContributor.Operation.DELETE, (Object)"DELETE").put((Object)GraphQLDTOContributor.Operation.GET, (Object)"GET").put((Object)GraphQLDTOContributor.Operation.GET_RELATIONSHIP, (Object)"GET").put((Object)GraphQLDTOContributor.Operation.LIST, (Object)"GET").put((Object)GraphQLDTOContributor.Operation.UPDATE, (Object)"PUT").build();
    private final GraphQLDTOContributor _graphQLDTOContributor;
    private final GraphQLDTOContributorDataFetchingProcessor _graphQLDTOContributorDataFetchingProcessor;
    private final GraphQLDTOProperty _graphQLDTOProperty;
    private final String _httpMethod;
    private final GraphQLDTOContributor.Operation _operation;

    public GraphQLDTOContributorDataFetcher(GraphQLDTOContributor graphQLDTOContributor, GraphQLDTOContributorDataFetchingProcessor graphQLDTOContributorDataFetchingProcessor, GraphQLDTOProperty graphQLDTOProperty, GraphQLRequestContext graphQLRequestContext, ServiceTrackerList<GraphQLRequestContextValidator> graphQLRequestContextValidators, GraphQLDTOContributor.Operation operation) {
        super(graphQLRequestContext, graphQLRequestContextValidators);
        this._graphQLDTOContributor = graphQLDTOContributor;
        this._graphQLDTOContributorDataFetchingProcessor = graphQLDTOContributorDataFetchingProcessor;
        this._graphQLDTOProperty = graphQLDTOProperty;
        this._operation = operation;
        this._httpMethod = _httpMethods.get(operation);
    }

    public GraphQLDTOContributorDataFetcher(GraphQLDTOContributor graphQLDTOContributor, GraphQLDTOContributorDataFetchingProcessor graphQLDTOContributorDataFetchingProcessor, GraphQLRequestContext graphQLRequestContext, ServiceTrackerList<GraphQLRequestContextValidator> graphQLRequestContextValidators, GraphQLDTOContributor.Operation operation) {
        this(graphQLDTOContributor, graphQLDTOContributorDataFetchingProcessor, null, graphQLRequestContext, graphQLRequestContextValidators, operation);
    }

    @Override
    public Object get(DataFetchingEnvironment dataFetchingEnvironment, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletRequest = new HttpServletRequestWrapper((HttpServletRequest)httpServletRequest){

            public String getMethod() {
                return GraphQLDTOContributorDataFetcher.this._httpMethod;
            }
        };
        if (this._operation == GraphQLDTOContributor.Operation.CREATE) {
            return this._graphQLDTOContributorDataFetchingProcessor.create(dataFetchingEnvironment.getArgument(this._graphQLDTOContributor.getResourceName()), this._graphQLDTOContributor, (HttpServletRequest)httpServletRequest, (String)dataFetchingEnvironment.getArgument("scopeKey"));
        }
        if (this._operation == GraphQLDTOContributor.Operation.DELETE) {
            return this._graphQLDTOContributorDataFetchingProcessor.delete(this._graphQLDTOContributor, (Long)dataFetchingEnvironment.getArgument(this._graphQLDTOContributor.getIdName()));
        }
        if (this._operation == GraphQLDTOContributor.Operation.GET) {
            return this._graphQLDTOContributorDataFetchingProcessor.get(this._graphQLDTOContributor, (HttpServletRequest)httpServletRequest, (Long)dataFetchingEnvironment.getArgument(this._graphQLDTOContributor.getIdName()));
        }
        if (this._operation == GraphQLDTOContributor.Operation.GET_RELATIONSHIP) {
            Map source = (Map)dataFetchingEnvironment.getSource();
            Object id = source.get(this._graphQLDTOContributor.getIdName());
            if (!(id instanceof Long)) {
                return null;
            }
            return this._graphQLDTOContributorDataFetchingProcessor.getRelationship(this._graphQLDTOContributor, this._graphQLDTOProperty, (HttpServletRequest)httpServletRequest, (Long)id);
        }
        if (this._operation == GraphQLDTOContributor.Operation.LIST) {
            return this._graphQLDTOContributorDataFetchingProcessor.list((List)dataFetchingEnvironment.getArgument("aggregation"), (String)dataFetchingEnvironment.getArgument("filter"), this._graphQLDTOContributor, (HttpServletRequest)httpServletRequest, (Integer)dataFetchingEnvironment.getArgument("page"), (Integer)dataFetchingEnvironment.getArgument("pageSize"), (String)dataFetchingEnvironment.getArgument("scopeKey"), (String)dataFetchingEnvironment.getArgument("search"), (String)dataFetchingEnvironment.getArgument("sort"));
        }
        if (this._operation == GraphQLDTOContributor.Operation.UPDATE) {
            return this._graphQLDTOContributorDataFetchingProcessor.update(dataFetchingEnvironment.getArgument(this._graphQLDTOContributor.getResourceName()), this._graphQLDTOContributor, (HttpServletRequest)httpServletRequest, (Long)dataFetchingEnvironment.getArgument(this._graphQLDTOContributor.getIdName()));
        }
        throw new UnsupportedOperationException("Operation not supported: " + this._operation);
    }
}

