/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.data.processor;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOProperty;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.AggregationContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.FilterContextProvider;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.provider.PaginationProvider;
import com.liferay.portal.vulcan.util.SortUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class GraphQLDTOContributorDataFetchingProcessor {
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final ExpressionConvert<Filter> _expressionConvert;
    private final FilterParserProvider _filterParserProvider;
    private final Language _language;
    private final PaginationProvider _paginationProvider;
    private final Portal _portal;
    private final SortParserProvider _sortParserProvider;

    public GraphQLDTOContributorDataFetchingProcessor(DTOConverterRegistry dtoConverterRegistry, ExpressionConvert<Filter> expressionConvert, FilterParserProvider filterParserProvider, Language language, PaginationProvider paginationProvider, Portal portal, SortParserProvider sortParserProvider) {
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._expressionConvert = expressionConvert;
        this._filterParserProvider = filterParserProvider;
        this._language = language;
        this._paginationProvider = paginationProvider;
        this._portal = portal;
        this._sortParserProvider = sortParserProvider;
    }

    public Object create(Object dto, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, String scopeKey) throws Exception {
        return graphQLDTOContributor.createDTO(dto, this._getDTOConverterContext(httpServletRequest, HashMapBuilder.put((Object)"scopeKey", (Object)scopeKey).build()));
    }

    public boolean delete(GraphQLDTOContributor graphQLDTOContributor, long id) throws Exception {
        return graphQLDTOContributor.deleteDTO(id);
    }

    public Object get(GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.getDTO(this._getDTOConverterContext(httpServletRequest, null), id);
    }

    public Object getRelationship(GraphQLDTOContributor graphQLDTOContributor, GraphQLDTOProperty graphQLDTOProperty, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.getRelationshipValue(this._getDTOConverterContext(httpServletRequest, null), id, graphQLDTOProperty.getTypeClass(), graphQLDTOProperty.getName());
    }

    public Page<Object> list(List<String> aggregations, String filterString, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, int page, int pageSize, String scopeKey, String search, String sortsString) throws Exception {
        Aggregation aggregation = null;
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        if (aggregations != null) {
            aggregation = this._getAggregation(acceptLanguage, aggregations, graphQLDTOContributor.getEntityModel());
        }
        return graphQLDTOContributor.getDTOs(aggregation, this._getDTOConverterContext(httpServletRequest, HashMapBuilder.put((Object)"companyId", (Object)CompanyThreadLocal.getCompanyId()).put((Object)"filter", (Object)filterString).put((Object)"scopeKey", (Object)scopeKey).build()), this._getFilter(acceptLanguage, graphQLDTOContributor.getEntityModel(), filterString), this._paginationProvider.getPagination(this._portal.getCompanyId(httpServletRequest), Integer.valueOf(page), Integer.valueOf(pageSize)), search, SortUtil.getSorts((AcceptLanguage)acceptLanguage, (EntityModel)graphQLDTOContributor.getEntityModel(), (SortParser)this._sortParserProvider.provide(graphQLDTOContributor.getEntityModel()), (String)sortsString));
    }

    public Object update(Object dto, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.updateDTO(dto, this._getDTOConverterContext(httpServletRequest, null), id);
    }

    private Aggregation _getAggregation(AcceptLanguage acceptLanguage, List<String> aggregationStrings, EntityModel entityModel) {
        if (aggregationStrings == null) {
            return null;
        }
        AggregationContextProvider aggregationContextProvider = new AggregationContextProvider(this._language, this._portal);
        return aggregationContextProvider.createContext(acceptLanguage, aggregationStrings.toArray(new String[0]), entityModel);
    }

    private DTOConverterContext _getDTOConverterContext(HttpServletRequest httpServletRequest, Map<String, Serializable> attributes) throws Exception {
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(acceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, null, acceptLanguage.getPreferredLocale(), null, this._portal.getUser(httpServletRequest));
        if (attributes != null) {
            defaultDTOConverterContext.setAttributes(attributes);
        }
        return defaultDTOConverterContext;
    }

    private Filter _getFilter(AcceptLanguage acceptLanguage, EntityModel entityModel, String filterString) throws Exception {
        FilterContextProvider filterContextProvider = new FilterContextProvider(this._expressionConvert, this._filterParserProvider, this._language, this._portal);
        return filterContextProvider.createContext(acceptLanguage, entityModel, filterString);
    }
}

