/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.validation;

import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.graphql.validation.GraphQLRequestContext;
import java.lang.reflect.Method;
import java.util.Objects;

public class ServletDataRequestContext
implements GraphQLRequestContext {
    private final long _companyId;
    private final String _namespace;
    private final Class<?> _resourceClass;
    private final Method _resourceMethod;
    private final ServletData _servletData;

    public ServletDataRequestContext(long companyId, Method method, boolean mutation, ServletData servletData) {
        this._companyId = companyId;
        this._servletData = servletData;
        this._namespace = this._getNamespace(servletData);
        this._resourceClass = this._getResourceClass(method, mutation, servletData);
        this._resourceMethod = this._getResourceMethod(method, mutation, servletData);
    }

    public String getApplicationName() {
        return this._servletData.getApplicationName();
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public Class<?> getResourceClass() {
        return this._resourceClass;
    }

    public Method getResourceMethod() {
        return this._resourceMethod;
    }

    public boolean isJaxRsResourceInvocation() {
        return this._servletData.isJaxRsResourceInvocation();
    }

    private String _getMethodName(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == null) {
            return method.getName();
        }
        GraphQLTypeExtension graphQLTypeExtension = declaringClass.getAnnotation(GraphQLTypeExtension.class);
        if (graphQLTypeExtension == null) {
            return method.getName();
        }
        Class value = graphQLTypeExtension.value();
        return value.getSimpleName() + "." + method.getName();
    }

    private String _getNamespace(ServletData servletData) {
        if (servletData == null || servletData.getGraphQLNamespace() == null) {
            return null;
        }
        return StringUtil.upperCaseFirstLetter((String)servletData.getGraphQLNamespace());
    }

    private Class<?> _getResourceClass(Method method, boolean mutation, ServletData servletData) {
        if (servletData == null) {
            return null;
        }
        ObjectValuePair resourceMethodObjectValuePair = servletData.getResourceMethodObjectValuePair(this._getMethodName(method), mutation);
        if (resourceMethodObjectValuePair == null) {
            return null;
        }
        return (Class)resourceMethodObjectValuePair.getKey();
    }

    private Method _getResourceMethod(Method method, boolean mutation, ServletData servletData) {
        if (servletData == null) {
            return null;
        }
        ObjectValuePair resourceMethodObjectValuePair = servletData.getResourceMethodObjectValuePair(this._getMethodName(method), mutation);
        if (resourceMethodObjectValuePair == null) {
            return null;
        }
        Class resourceClass = (Class)resourceMethodObjectValuePair.getKey();
        for (Method resourceMethod : resourceClass.getMethods()) {
            if (!Objects.equals(resourceMethod.getName(), resourceMethodObjectValuePair.getValue())) continue;
            return resourceMethod;
        }
        return null;
    }
}

