/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResourceFactory;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResourceFactory;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.configuration.util.ConfigurationUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.osgi.service.cm.ConfigurationAdmin;

@Provider
public class ContextContainerRequestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final ConfigurationAdmin _configurationAdmin;
    private final ExpressionConvert<Filter> _expressionConvert;
    private final FilterParserProvider _filterParserProvider;
    private final GroupLocalService _groupLocalService;
    private final Language _language;
    private final Portal _portal;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final Object _scopeChecker;
    private final SortParserProvider _sortParserProvider;
    private final VulcanBatchEngineExportTaskResourceFactory _vulcanBatchEngineExportTaskResourceFactory;
    private final VulcanBatchEngineImportTaskResourceFactory _vulcanBatchEngineImportTaskResourceFactory;

    public ContextContainerRequestFilter(ConfigurationAdmin configurationAdmin, ExpressionConvert<Filter> expressionConvert, FilterParserProvider filterParserProvider, GroupLocalService groupLocalService, Language language, Portal portal, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, Object scopeChecker, SortParserProvider sortParserProvider, VulcanBatchEngineExportTaskResourceFactory vulcanBatchEngineExportTaskResourceFactory, VulcanBatchEngineImportTaskResourceFactory vulcanBatchEngineImportTaskResourceFactory) {
        this._configurationAdmin = configurationAdmin;
        this._expressionConvert = expressionConvert;
        this._filterParserProvider = filterParserProvider;
        this._groupLocalService = groupLocalService;
        this._language = language;
        this._portal = portal;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._scopeChecker = scopeChecker;
        this._sortParserProvider = sortParserProvider;
        this._vulcanBatchEngineExportTaskResourceFactory = vulcanBatchEngineExportTaskResourceFactory;
        this._vulcanBatchEngineImportTaskResourceFactory = vulcanBatchEngineImportTaskResourceFactory;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        this.handleMessage(containerRequestContext, PhaseInterceptorChain.getCurrentMessage());
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        ContextProviderUtil.releaseResourceInstance(JAXRSUtils.getContextMessage((Message)JAXRSUtils.getCurrentMessage()));
    }

    public void handleMessage(ContainerRequestContext containerRequestContext, Message message) throws Fault {
        try {
            this._handleMessage(containerRequestContext, message);
        }
        catch (Exception exception) {
            throw new Fault((Throwable)exception);
        }
    }

    private void _filterExcludedOperationIds(ContainerRequestContext containerRequestContext, HttpServletRequest httpServletRequest, Message message) throws Exception {
        Method method;
        Company company = this._portal.getCompany(httpServletRequest);
        String path = StringUtil.removeFirst((String)((String)message.get((Object)Message.BASE_PATH)), (String)"/o");
        path = StringUtil.replaceLast((String)path, (char)'/', (String)"");
        Set<String> excludedOperationIds = ConfigurationUtil.getExcludedOperationIds(company.getCompanyId(), this._configurationAdmin, path);
        if (excludedOperationIds.contains((method = (Method)message.get((Object)"org.apache.cxf.resource.method")).getName())) {
            containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Conflict with " + method.getName())).build());
        }
    }

    private UriInfo _getVulcanUriInfo(HttpServletRequest httpServletRequest, Message message) {
        UriInfoImpl uriInfo = new UriInfoImpl(message);
        return new UriInfo(){
            final /* synthetic */ UriInfo val$uriInfo;
            final /* synthetic */ HttpServletRequest val$httpServletRequest;
            {
                this.val$uriInfo = uriInfo;
                this.val$httpServletRequest = httpServletRequest;
            }

            public URI getAbsolutePath() {
                return this.val$uriInfo.getAbsolutePath();
            }

            public UriBuilder getAbsolutePathBuilder() {
                return this.val$uriInfo.getAbsolutePathBuilder();
            }

            public URI getBaseUri() {
                return this.val$uriInfo.getBaseUri();
            }

            public UriBuilder getBaseUriBuilder() {
                return UriInfoUtil.getBaseUriBuilder((HttpServletRequest)this.val$httpServletRequest, (UriInfo)this.val$uriInfo);
            }

            public List<Object> getMatchedResources() {
                return this.val$uriInfo.getMatchedResources();
            }

            public List<String> getMatchedURIs() {
                return this.val$uriInfo.getMatchedURIs();
            }

            public List<String> getMatchedURIs(boolean decode) {
                return this.val$uriInfo.getMatchedURIs(decode);
            }

            public String getPath() {
                return this.val$uriInfo.getPath();
            }

            public String getPath(boolean decode) {
                return this.val$uriInfo.getPath(decode);
            }

            public MultivaluedMap<String, String> getPathParameters() {
                return this.val$uriInfo.getPathParameters();
            }

            public MultivaluedMap<String, String> getPathParameters(boolean decode) {
                return this.val$uriInfo.getPathParameters(decode);
            }

            public List<PathSegment> getPathSegments() {
                return this.val$uriInfo.getPathSegments();
            }

            public List<PathSegment> getPathSegments(boolean decode) {
                return this.val$uriInfo.getPathSegments(decode);
            }

            public MultivaluedMap<String, String> getQueryParameters() {
                return this.val$uriInfo.getQueryParameters();
            }

            public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
                return this.val$uriInfo.getQueryParameters(decode);
            }

            public URI getRequestUri() {
                return this.val$uriInfo.getRequestUri();
            }

            public UriBuilder getRequestUriBuilder() {
                return this.val$uriInfo.getRequestUriBuilder();
            }

            public URI relativize(URI uri) {
                return this.val$uriInfo.relativize(uri);
            }

            public URI resolve(URI uri) {
                return this.val$uriInfo.resolve(uri);
            }
        };
    }

    private void _handleMessage(ContainerRequestContext containerRequestContext, Message message) throws Exception {
        Object instance = ContextProviderUtil.getMatchedResource(message);
        if (instance == null) {
            return;
        }
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        this._filterExcludedOperationIds(containerRequestContext, httpServletRequest, message);
        this._setInstanceFields(instance.getClass(), httpServletRequest, message, instance);
    }

    private void _setInstanceFields(Class<?> clazz, HttpServletRequest httpServletRequest, Message message, Object instance) throws Exception {
        if (clazz == Object.class) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.equals(Object.class) && Objects.equals(field.getName(), "contextScopeChecker")) {
                field.setAccessible(true);
                field.set(instance, this._scopeChecker);
                continue;
            }
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, new AcceptLanguageImpl(httpServletRequest, this._language, this._portal));
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getCompany(httpServletRequest));
                continue;
            }
            if (fieldClass.isAssignableFrom(ExpressionConvert.class)) {
                field.setAccessible(true);
                field.set(instance, this._expressionConvert);
                continue;
            }
            if (fieldClass.isAssignableFrom(FilterParserProvider.class)) {
                field.setAccessible(true);
                field.set(instance, this._filterParserProvider);
                continue;
            }
            if (fieldClass.isAssignableFrom(GroupLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._groupLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, message.getContextualProperty("HTTP.RESPONSE"));
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourceActionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourceActionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourcePermissionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourcePermissionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(RoleLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._roleLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(SortParserProvider.class)) {
                field.setAccessible(true);
                field.set(instance, this._sortParserProvider);
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, this._getVulcanUriInfo(httpServletRequest, message));
                continue;
            }
            if (fieldClass.isAssignableFrom(User.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getUser(httpServletRequest));
                continue;
            }
            if (fieldClass.isAssignableFrom(VulcanBatchEngineExportTaskResource.class)) {
                field.setAccessible(true);
                field.set(instance, this._vulcanBatchEngineExportTaskResourceFactory.create());
                continue;
            }
            if (!fieldClass.isAssignableFrom(VulcanBatchEngineImportTaskResource.class)) continue;
            field.setAccessible(true);
            field.set(instance, this._vulcanBatchEngineImportTaskResourceFactory.create());
        }
        this._setInstanceFields(clazz.getSuperclass(), httpServletRequest, message, instance);
    }
}

