/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionExecutor;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import com.liferay.portal.vulcan.internal.constants.VulcanConstants;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

@Provider
@Transactional(rollbackFor={Exception.class})
public class TransactionContainerRequestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Log _log = LogFactoryUtil.getLog(TransactionContainerRequestFilter.class);
    private static final TransactionAttributeAdapter _transactionAttributeAdapter = new TransactionAttributeAdapter(TransactionAttributeBuilder.build((Transactional)TransactionContainerRequestFilter.class.getAnnotation(Transactional.class)));
    private static final TransactionExecutor _transactionExecutor = (TransactionExecutor)PortalBeanLocatorUtil.locate((String)"transactionExecutor");
    private static final Set<String> _transactionRequiredMethodNames = new HashSet<String>(Arrays.asList("DELETE", "PATCH", "POST", "PUT"));

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (GetterUtil.getBoolean((String)containerRequestContext.getHeaderString("X-Liferay-Transaction-Disabled"))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Transaction management is disabled");
            }
            return;
        }
        if (_transactionRequiredMethodNames.contains(containerRequestContext.getMethod())) {
            Message message = PhaseInterceptorChain.getCurrentMessage();
            InterceptorChain interceptorChain = message.getInterceptorChain();
            TransactionCleanUpMessageObserver transactionCleanUpMessageObserver = new TransactionCleanUpMessageObserver(interceptorChain.getFaultObserver(), _transactionExecutor.start(_transactionAttributeAdapter));
            containerRequestContext.setProperty(VulcanConstants.TRANSACTION_CLEAN_UP_MESSAGE_OBSERVER, (Object)transactionCleanUpMessageObserver);
            interceptorChain.add((Interceptor)transactionCleanUpMessageObserver);
            interceptorChain.setFaultObserver((MessageObserver)transactionCleanUpMessageObserver);
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        TransactionCleanUpMessageObserver transactionCleanUpMessageObserver = (TransactionCleanUpMessageObserver)((Object)containerRequestContext.getProperty(VulcanConstants.TRANSACTION_CLEAN_UP_MESSAGE_OBSERVER));
        if (transactionCleanUpMessageObserver == null) {
            return;
        }
        Response.Status.Family family = Response.Status.Family.familyOf((int)containerResponseContext.getStatus());
        if (family == Response.Status.Family.SUCCESSFUL) {
            transactionCleanUpMessageObserver.commit();
        } else {
            transactionCleanUpMessageObserver.rollback(StringBundler.concat((Object[])new Object[]{"Rollback due to ", family, ": ", containerResponseContext.getStatus()}));
        }
    }

    private static class TransactionCleanUpMessageObserver
    extends AbstractPhaseInterceptor
    implements MessageObserver {
        private boolean _complete;
        private final MessageObserver _messageObserver;
        private final TransactionStatusAdapter _transactionStatusAdapter;

        public void commit() {
            try {
                _transactionExecutor.commit(_transactionAttributeAdapter, this._transactionStatusAdapter);
            }
            finally {
                this._complete = true;
            }
        }

        public void handleFault(Message message) {
            if (!this._complete) {
                this.rollback("Rollback due to uncaught exception");
            }
        }

        public void handleMessage(Message message) {
            if (!this._complete) {
                this.rollback("Rollback due to uncaught exception");
            }
        }

        public void onMessage(Message message) {
            if (!this._complete) {
                this.rollback("Rollback due to uncaught exception");
            }
            this._messageObserver.onMessage(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(String message) {
            Exception exception = new Exception(message);
            try {
                _transactionExecutor.rollback((Throwable)exception, _transactionAttributeAdapter, this._transactionStatusAdapter);
            }
            catch (Throwable throwable) {
                if (throwable != exception) {
                    _log.error((Object)"Unable to roll back the transaction", throwable);
                }
            }
            finally {
                this._complete = true;
            }
        }

        private TransactionCleanUpMessageObserver(MessageObserver messageObserver, TransactionStatusAdapter transactionStatusAdapter) {
            super("post-invoke");
            this._messageObserver = messageObserver;
            this._transactionStatusAdapter = transactionStatusAdapter;
        }
    }
}

