/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.response.filter;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.liferay.petra.io.DummyOutputStream;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.fields.FieldsQueryParam;
import com.liferay.portal.vulcan.fields.RestrictFieldsQueryParam;
import com.liferay.portal.vulcan.jackson.databind.ser.VulcanPropertyFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
public class EntityFieldsPreSerializerContainerResponseFilter
implements ContainerResponseFilter {
    private static final Map<MediaType, Class<? extends ObjectMapper>> _mediaTypeObjectMappers = HashMapBuilder.put((Object)MediaType.APPLICATION_JSON_TYPE, ObjectMapper.class).put((Object)MediaType.APPLICATION_XML_TYPE, XmlMapper.class).build();
    @Context
    private FieldsQueryParam _fieldsQueryParam;
    @Context
    private Providers _providers;
    @Context
    private RestrictFieldsQueryParam _restrictFieldsQueryParam;

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        MediaType mediaType = containerResponseContext.getMediaType();
        if (containerResponseContext.getEntity() == null || !_mediaTypeObjectMappers.containsKey(mediaType)) {
            return;
        }
        ContextResolver contextResolver = this._providers.getContextResolver(_mediaTypeObjectMappers.get(mediaType), mediaType);
        ObjectMapper objectMapper = (ObjectMapper)contextResolver.getContext(ObjectMapper.class);
        try {
            objectMapper.writer((FilterProvider)this._getSimpleFilterProvider()).writeValue((OutputStream)new DummyOutputStream(), containerResponseContext.getEntity());
        }
        catch (JsonMappingException jsonMappingException) {
            if (jsonMappingException.getCause() != null) {
                throw new RuntimeException(jsonMappingException.getCause());
            }
            throw jsonMappingException;
        }
    }

    private SimpleFilterProvider _getSimpleFilterProvider() {
        return new SimpleFilterProvider(){
            {
                this.addFilter("Liferay.Vulcan", (SimpleBeanPropertyFilter)VulcanPropertyFilter.of((Set)EntityFieldsPreSerializerContainerResponseFilter.this._fieldsQueryParam.getFieldNames(), (Set)EntityFieldsPreSerializerContainerResponseFilter.this._restrictFieldsQueryParam.getRestrictFieldNames()));
            }
        };
    }
}

