/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.internal.jaxrs.lifecycle.SafeReleaseInstanceResourceProvider;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ContextProviderUtil {
    public static EntityModel getEntityModel(Message message) throws Exception {
        Object matchedResource = ContextProviderUtil.getMatchedResource(message);
        if (matchedResource instanceof EntityModelResource) {
            EntityModelResource entityModelResource = (EntityModelResource)matchedResource;
            return entityModelResource.getEntityModel(ContextProviderUtil._getPathParameters(message));
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest(Message message) {
        return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
    }

    public static Object getMatchedResource(Message message) {
        return ContextProviderUtil._getMatchedResource(true, message);
    }

    public static MultivaluedHashMap<String, String> getMultivaluedHashMap(final Map<String, String[]> parameterMap) {
        return new MultivaluedHashMap<String, String>(){
            {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    this.put((String)entry.getKey(), Arrays.asList((String[])entry.getValue()));
                }
            }
        };
    }

    public static void releaseResourceInstance(Message message) {
        Exchange exchange = message.getExchange();
        Object resource = ContextProviderUtil._getMatchedResource(false, message);
        if (resource == null) {
            return;
        }
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo classResourceInfo = operationResourceInfo.getClassResourceInfo();
        ResourceProvider resourceProvider = classResourceInfo.getResourceProvider();
        if (resourceProvider != null) {
            resourceProvider.releaseInstance(message, resource);
        }
    }

    private static Object _fetchExistingResource(Exchange exchange, String ... keys) {
        Object resource = null;
        for (int i = 0; i < keys.length && resource == null; ++i) {
            resource = exchange.get((Object)keys[i]);
        }
        return resource;
    }

    private static Object _getMatchedResource(boolean initialize, Message message) {
        Exchange exchange = message.getExchange();
        Object resource = ContextProviderUtil._fetchExistingResource(exchange, "service.root.instance", "org.apache.cxf.service.object.last");
        if (resource != null) {
            return resource;
        }
        OperationResourceInfo operationResourceInfo = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        if (operationResourceInfo == null) {
            return null;
        }
        ResourceContextImpl resourceContext = new ResourceContextImpl(message, operationResourceInfo);
        ClassResourceInfo classResourceInfo = operationResourceInfo.getClassResourceInfo();
        ResourceProvider resourceProvider = classResourceInfo.getResourceProvider();
        if (resourceProvider != null) {
            if (!(resourceProvider instanceof SafeReleaseInstanceResourceProvider)) {
                classResourceInfo.setResourceProvider((ResourceProvider)new SafeReleaseInstanceResourceProvider(resourceProvider));
            }
            Object instance = resourceProvider.getInstance(message);
            if (initialize) {
                resourceContext.initResource(instance);
            }
            return instance;
        }
        UriInfoImpl uriInfo = new UriInfoImpl(message);
        List matchedResources = uriInfo.getMatchedResources();
        Class matchedResourceClass = (Class)matchedResources.get(0);
        return resourceContext.getResource(matchedResourceClass);
    }

    private static MultivaluedMap<String, String> _getPathParameters(Message message) {
        UriInfoImpl uriInfoImpl = new UriInfoImpl(message);
        return uriInfoImpl.getPathParameters();
    }
}

