/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.vulcan.fields.FieldsQueryParam;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class FieldsQueryParamContextProvider
implements ContextProvider<FieldsQueryParam> {
    public FieldsQueryParam createContext(Message message) {
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        String fieldNamesString = httpServletRequest.getParameter("fields");
        if (fieldNamesString == null) {
            return () -> null;
        }
        if (fieldNamesString.isEmpty()) {
            return Collections::emptySet;
        }
        HashSet<String> paths = new HashSet<String>();
        for (String fieldName : fieldNamesString.split(",")) {
            paths.addAll(this._toPaths(fieldName));
        }
        return () -> paths;
    }

    private List<String> _toPaths(String string) {
        if (!string.contains(".")) {
            return Collections.singletonList(string);
        }
        ArrayList<String> list = new ArrayList<String>();
        String pending = string;
        while (!pending.equals("")) {
            list.add(pending);
            if (pending.contains(".")) {
                pending = pending.substring(0, pending.lastIndexOf("."));
                continue;
            }
            pending = "";
        }
        return list;
    }
}

