/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.pagination.provider.PaginationProvider;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class PaginationContextProvider
implements ContextProvider<Pagination> {
    private final PaginationProvider _paginationProvider;
    private final Portal _portal;

    public PaginationContextProvider(PaginationProvider paginationProvider, Portal portal) {
        this._paginationProvider = paginationProvider;
        this._portal = portal;
    }

    public Pagination createContext(Message message) {
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        return this._paginationProvider.getPagination(this._portal.getCompanyId(httpServletRequest), this._getIntegerValue(httpServletRequest, "page"), this._getIntegerValue(httpServletRequest, "pageSize"));
    }

    private Integer _getIntegerValue(HttpServletRequest httpServletRequest, String key) {
        String value = httpServletRequest.getParameter(key);
        if (Validator.isNotNull((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }
}

