/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.exception.mapper;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.BaseExceptionMapper;
import com.liferay.portal.vulcan.jaxrs.exception.mapper.Problem;
import com.liferay.portal.vulcan.problem.Problem;
import com.liferay.portal.vulcan.problem.ProblemProvider;
import java.util.Locale;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;

public class ExceptionMapper
extends BaseExceptionMapper<Exception> {
    private static final Log _log = LogFactoryUtil.getLog(ExceptionMapper.class);
    private static final Snapshot<ProblemProvider> _problemProviderRegistrySnapshot = new Snapshot(ExceptionMapper.class, ProblemProvider.class);
    @Context
    private AcceptLanguage _acceptLanguage;
    @Context
    private Providers _providers;

    public Response toResponse(Exception exception) {
        Class<?> exceptionClass = exception.getClass();
        String exceptionClassName = exceptionClass.getSimpleName();
        if (exceptionClassName.startsWith("Duplicate") && exceptionClassName.endsWith("ExternalReferenceCodeException")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).type(this.getMediaType()).build();
        }
        Throwable throwable = exception.getCause();
        if (throwable == null) {
            return super.toResponse((Throwable)exception);
        }
        javax.ws.rs.ext.ExceptionMapper exceptionMapper = this._providers.getExceptionMapper(throwable.getClass());
        if (exceptionMapper != null) {
            return exceptionMapper.toResponse(throwable);
        }
        return super.toResponse((Throwable)exception);
    }

    protected Problem getProblem(Exception exception) {
        ProblemProvider problemProvider = (ProblemProvider)_problemProviderRegistrySnapshot.get();
        com.liferay.portal.vulcan.problem.Problem problem = problemProvider.getProblem((Throwable)exception);
        if (problem != null) {
            Locale locale = this._acceptLanguage.getPreferredLocale();
            return new Problem(problem.getDetail(locale), this._getResponseStatus(problem.getStatus()), problem.getTitle(locale), problem.getType());
        }
        _log.error((Throwable)exception);
        return new Problem(Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
    }

    private Response.Status _getResponseStatus(Problem.Status status) {
        if (Problem.Status.BAD_REQUEST.equals((Object)status)) {
            return Response.Status.BAD_REQUEST;
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

