/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.extension.EntityExtensionThreadLocal;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidationUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;

public abstract class BaseMessageBodyReader
implements MessageBodyReader<Object> {
    @Context
    private Company _company;
    private final Class<? extends ObjectMapper> _contextType;
    @Context
    private HttpServletRequest _httpServletRequest;
    private final MediaType _mediaType;
    @Context
    private Providers _providers;

    public BaseMessageBodyReader(Class<? extends ObjectMapper> contextType, MediaType mediaType) {
        this._contextType = contextType;
        this._mediaType = mediaType;
    }

    public boolean isReadable(Class clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException {
        Object object = null;
        ObjectMapper objectMapper = this._getObjectMapper(clazz);
        ObjectReader objectReader = objectMapper.readerFor(clazz);
        EntityExtensionHandler entityExtensionHandler = this._getEntityExtensionHandler(clazz, mediaType);
        if (this._isCreateOrUpdateMethod(this._httpServletRequest.getMethod()) && entityExtensionHandler != null) {
            JsonNode jsonNode = objectReader.readTree(inputStream);
            objectReader = objectReader.without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            object = objectReader.readValue(jsonNode);
            Map<String, Serializable> extendedProperties = this._getExtendedProperties(clazz, jsonNode, objectMapper);
            try {
                entityExtensionHandler.validate(this._company.getCompanyId(), extendedProperties, Objects.equals(this._httpServletRequest.getMethod(), "PATCH"));
                EntityExtensionThreadLocal.setExtendedProperties(extendedProperties);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        } else {
            object = objectReader.readValue(inputStream);
        }
        if (!StringUtil.equals((String)this._httpServletRequest.getMethod(), (String)"PATCH")) {
            ValidationUtil.validate(object);
        }
        return object;
    }

    private EntityExtensionHandler _getEntityExtensionHandler(Class<?> clazz, MediaType mediaType) {
        ContextResolver contextResolver = this._providers.getContextResolver(EntityExtensionHandler.class, mediaType);
        if (contextResolver == null) {
            return null;
        }
        return (EntityExtensionHandler)contextResolver.getContext(clazz);
    }

    private Map<String, Serializable> _getExtendedProperties(Class<?> clazz, JsonNode jsonNode, ObjectMapper objectMapper) throws IOException {
        HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (StringUtil.equals((String)"_extendedProperties", (String)field.getName())) continue;
            fieldNames.add(field.getName());
        }
        Iterator iterator = jsonNode.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            if (fieldNames.contains(fieldName)) continue;
            extendedProperties.put(fieldName, this._getJsonNodeValue(jsonNode.get(fieldName), objectMapper));
        }
        return extendedProperties;
    }

    private Serializable _getJsonNodeValue(JsonNode jsonNode, ObjectMapper objectMapper) throws IOException {
        if (jsonNode.isArray()) {
            return (Serializable)objectMapper.readValue(jsonNode.traverse(), Object[].class);
        }
        if (jsonNode.isBoolean()) {
            return Boolean.valueOf(jsonNode.asBoolean());
        }
        if (jsonNode.isDouble()) {
            return Double.valueOf(jsonNode.asDouble());
        }
        if (jsonNode.isInt()) {
            return Integer.valueOf(jsonNode.asInt());
        }
        if (jsonNode.isLong()) {
            return Long.valueOf(jsonNode.asLong());
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        if (jsonNode.isObject()) {
            return (Serializable)objectMapper.readValue(jsonNode.traverse(), Object.class);
        }
        return null;
    }

    private ObjectMapper _getObjectMapper(Class<?> clazz) {
        ObjectMapper objectMapper;
        ContextResolver contextResolver = this._providers.getContextResolver(this._contextType, this._mediaType);
        if (contextResolver != null && (objectMapper = (ObjectMapper)contextResolver.getContext(clazz)) != null) {
            return objectMapper;
        }
        throw new InternalServerErrorException("Unable to generate object mapper for class " + clazz);
    }

    private boolean _isCreateOrUpdateMethod(String method) {
        return Objects.equals(method, "PATCH") || Objects.equals(method, "POST") || Objects.equals(method, "PUT");
    }
}

