/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.liferay.portal.vulcan.fields.FieldsQueryParam;
import com.liferay.portal.vulcan.fields.RestrictFieldsQueryParam;
import com.liferay.portal.vulcan.jackson.databind.ser.VulcanPropertyFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

public abstract class BaseMessageBodyWriter
implements MessageBodyWriter<Object> {
    private final Class<? extends ObjectMapper> _contextType;
    @Context
    private FieldsQueryParam _fieldsQueryParam;
    private final MediaType _mediaType;
    @Context
    private Providers _providers;
    @Context
    private RestrictFieldsQueryParam _restrictFieldsQueryParam;

    public BaseMessageBodyWriter(Class<? extends ObjectMapper> contextType, MediaType mediaType) {
        this._contextType = contextType;
        this._mediaType = mediaType;
    }

    public boolean isWriteable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ObjectMapper objectMapper = this._getObjectMapper(clazz);
        return objectMapper.canSerialize(clazz);
    }

    public void writeTo(Object object, Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        ObjectMapper objectMapper = this._getObjectMapper(clazz);
        objectMapper.writer((FilterProvider)this._getSimpleFilterProvider()).writeValue(outputStream, object);
        outputStream.flush();
    }

    private ObjectMapper _getObjectMapper(Class<?> clazz) {
        ObjectMapper objectMapper;
        ContextResolver contextResolver = this._providers.getContextResolver(this._contextType, this._mediaType);
        if (contextResolver != null && (objectMapper = (ObjectMapper)contextResolver.getContext(clazz)) != null) {
            return objectMapper;
        }
        throw new InternalServerErrorException("Unable to generate object mapper for class " + clazz);
    }

    private SimpleFilterProvider _getSimpleFilterProvider() {
        return new SimpleFilterProvider(){
            {
                this.addFilter("Liferay.Vulcan", (SimpleBeanPropertyFilter)VulcanPropertyFilter.of((Set)BaseMessageBodyWriter.this._fieldsQueryParam.getFieldNames(), (Set)BaseMessageBodyWriter.this._restrictFieldsQueryParam.getRestrictFieldNames()));
            }
        };
    }
}

