/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.message.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.commons.fileupload.util.Streams;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

@Consumes(value={"multipart/form-data"})
@Provider
public class MultipartBodyMessageBodyReader
implements MessageBodyReader<MultipartBody> {
    private static final Log _log = LogFactoryUtil.getLog(MultipartBodyMessageBodyReader.class);
    @Context
    private ObjectMapper _objectMapper;
    @Context
    private Providers _providers;

    public boolean isReadable(Class<?> clazz, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public MultipartBody readFrom(Class<MultipartBody> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) {
        HashMap<String, String> values;
        HashMap<String, BinaryFile> binaryFiles;
        UploadServletRequest uploadServletRequest;
        block13: {
            Message message = JAXRSUtils.getCurrentMessage();
            uploadServletRequest = this._getUploadServletRequest((ServletRequest)((HttpServletRequest)message.getContextualProperty("HTTP.REQUEST")));
            if (uploadServletRequest == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Upload servlet request is null");
                }
                return null;
            }
            UploadException uploadException = (UploadException)uploadServletRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                throw new BadRequestException("Please enter a file with a valid file size no larger than " + DLValidatorUtil.getMaxAllowableSize((long)0L, null), (Throwable)uploadException);
            }
            binaryFiles = new HashMap<String, BinaryFile>();
            values = new HashMap<String, String>();
            try {
                Collection parts = uploadServletRequest.getParts();
                if (parts != null && !parts.isEmpty()) {
                    for (Part part : parts) {
                        String fileName = MultipartUtil.getFileName(part);
                        if (fileName == null) {
                            values.put(part.getName(), Streams.asString((InputStream)part.getInputStream()));
                            continue;
                        }
                        binaryFiles.put(part.getName(), new BinaryFile(part.getContentType(), fileName, part.getInputStream(), part.getSize()));
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block13;
                _log.debug((Throwable)exception);
            }
        }
        if (binaryFiles.isEmpty() && values.isEmpty()) {
            try {
                Map multipartParameterMap = uploadServletRequest.getMultipartParameterMap();
                for (Map.Entry entry : multipartParameterMap.entrySet()) {
                    FileItem fileItem = ((FileItem[])entry.getValue())[0];
                    binaryFiles.put((String)entry.getKey(), new BinaryFile(fileItem.getContentType(), fileItem.getFileName(), fileItem.getInputStream(), fileItem.getSize()));
                }
                Map regularParameterMap = uploadServletRequest.getRegularParameterMap();
                for (Map.Entry entry : regularParameterMap.entrySet()) {
                    List parameterValues = (List)entry.getValue();
                    values.put((String)entry.getKey(), (String)parameterValues.get(0));
                }
            }
            catch (Exception exception) {
                throw new BadRequestException("Request body is not a valid multipart form", (Throwable)exception);
            }
        }
        ContextResolver contextResolver = this._providers.getContextResolver(ObjectMapper.class, MediaType.MULTIPART_FORM_DATA_TYPE);
        return MultipartBody.of(binaryFiles, arg_0 -> ((ContextResolver)contextResolver).getContext(arg_0), values);
    }

    private UploadServletRequest _getUploadServletRequest(ServletRequest servletRequest) {
        while (servletRequest instanceof ServletRequestWrapper) {
            if (servletRequest instanceof UploadServletRequest) {
                return (UploadServletRequest)servletRequest;
            }
            ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)servletRequest;
            servletRequest = servletRequestWrapper.getRequest();
        }
        if (servletRequest instanceof UploadServletRequest) {
            return (UploadServletRequest)servletRequest;
        }
        return null;
    }
}

