/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.param.converter.provider;

import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.vulcan.util.GroupUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

@Provider
public class SiteParamConverterProvider
implements ParamConverter<Long>,
ParamConverterProvider {
    @Context
    private Company _company;
    private final DepotEntryLocalService _depotEntryLocalService;
    private final GroupLocalService _groupLocalService;
    @Context
    private UriInfo _uriInfo;

    public SiteParamConverterProvider(DepotEntryLocalService depotEntryLocalService, GroupLocalService groupLocalService) {
        this._depotEntryLocalService = depotEntryLocalService;
        this._groupLocalService = groupLocalService;
    }

    public Long fromString(String parameter) {
        MultivaluedMap multivaluedMap = this._uriInfo.getPathParameters();
        Long siteId = null;
        siteId = multivaluedMap.containsKey((Object)"assetLibraryId") ? this.getDepotGroupId((String)multivaluedMap.getFirst((Object)"assetLibraryId"), this._company.getCompanyId()) : this.getGroupId(this._company.getCompanyId(), (String)multivaluedMap.getFirst((Object)"siteId"));
        if (siteId != null) {
            return siteId;
        }
        StringBundler sb = new StringBundler(4);
        sb.append("Unable to get a valid ");
        if (multivaluedMap.containsKey((Object)"assetLibraryId")) {
            sb.append("asset library");
        } else {
            sb.append("site");
        }
        sb.append(" with ID ");
        sb.append(parameter);
        throw new NotFoundException(sb.toString());
    }

    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (Long.class.equals(clazz) && this._hasSiteIdAnnotation(annotations)) {
            return this;
        }
        return null;
    }

    public Long getDepotGroupId(String assetLibraryKey, long companyId) {
        if (assetLibraryKey == null) {
            return null;
        }
        return GroupUtil.getDepotGroupId((String)assetLibraryKey, (long)companyId, (DepotEntryLocalService)this._depotEntryLocalService, (GroupLocalService)this._groupLocalService);
    }

    public Long getGroupId(long companyId, String siteKey) {
        if (siteKey == null) {
            return null;
        }
        return GroupUtil.getGroupId((long)companyId, (String)siteKey, (GroupLocalService)this._groupLocalService);
    }

    public String toString(Long parameter) {
        return String.valueOf(parameter);
    }

    private boolean _hasSiteIdAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != PathParam.class || !StringUtils.equalsAny((CharSequence)AnnotationUtils.getAnnotationValue((Annotation)annotation), (CharSequence[])new CharSequence[]{"assetLibraryId", "siteId"})) continue;
            return true;
        }
        return false;
    }
}

