/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.validation;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidationUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.validation.AbstractValidationInterceptor;

@Provider
public class BeanValidationInterceptor
extends AbstractValidationInterceptor
implements ContainerRequestFilter {
    public BeanValidationInterceptor() {
        super("pre-invoke");
    }

    public BeanValidationInterceptor(String phase) {
        super(phase);
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        InterceptorChain interceptorChain = message.getInterceptorChain();
        interceptorChain.add((Interceptor)this);
    }

    public void handleMessage(Message message) throws Fault {
        Object serviceObject = this.getServiceObject(message);
        if (serviceObject == null) {
            return;
        }
        Method method = this.getServiceMethod(message);
        if (method == null) {
            return;
        }
        MessageContentsList arguments = MessageContentsList.getContentsList((Message)message);
        this.handleValidation(message, serviceObject, method, (List<Object>)arguments);
    }

    protected Object getServiceObject(Message message) {
        return ContextProviderUtil.getMatchedResource(message);
    }

    protected void handleValidation(Message message, Object resource, Method method, List<Object> arguments) {
        if (ListUtil.isEmpty(arguments)) {
            return;
        }
        ValidationUtil.validateArguments(resource, method, arguments.toArray());
    }
}

