/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldsContext;
import com.liferay.portal.vulcan.fields.NestedFieldsContextThreadLocal;
import com.liferay.portal.vulcan.internal.fields.servlet.NestedFieldsHttpServletRequestWrapper;
import com.liferay.portal.vulcan.internal.jaxrs.message.exchange.ExchangeWrapper;
import com.liferay.portal.vulcan.pagination.Page;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Provider
public class NestedFieldsWriterInterceptor
implements WriterInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(NestedFieldsWriterInterceptor.class);
    private final NestedFieldServiceTrackerCustomizer _nestedFieldServiceTrackerCustomizer;
    private final ServiceTracker<Object, List<FactoryKey>> _serviceTracker;

    public NestedFieldsWriterInterceptor(BundleContext bundleContext) {
        this(bundleContext, null);
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (nestedFieldsContext == null || ListUtil.isEmpty((List)nestedFieldsContext.getNestedFields())) {
            writerInterceptorContext.proceed();
            return;
        }
        try {
            this._setFieldValues(writerInterceptorContext.getEntity(), nestedFieldsContext.getNestedFields(), nestedFieldsContext);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new WebApplicationException((Throwable)exception);
        }
        writerInterceptorContext.proceed();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    protected NestedFieldsWriterInterceptor(BundleContext bundleContext, NestedFieldServiceTrackerCustomizer nestedFieldServiceTrackerCustomizer) {
        if (nestedFieldServiceTrackerCustomizer == null) {
            nestedFieldServiceTrackerCustomizer = new NestedFieldServiceTrackerCustomizer(bundleContext);
        }
        this._nestedFieldServiceTrackerCustomizer = nestedFieldServiceTrackerCustomizer;
        Filter filter = null;
        try {
            filter = bundleContext.createFilter("(nested.field.support=true)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            ReflectionUtil.throwException((Throwable)invalidSyntaxException);
        }
        this._serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)this._nestedFieldServiceTrackerCustomizer);
        this._serviceTracker.open();
    }

    private static <A extends Annotation> A _getAnnotation(Class<A> annotationClass, Parameter parameter, Parameter[] parentParameters, int i) {
        A annotation = parameter.getAnnotation(annotationClass);
        if (annotation == null && parentParameters != null) {
            return parentParameters[i].getAnnotation(annotationClass);
        }
        return annotation;
    }

    private Object _adaptToFieldType(Class<?> fieldType, Object value) {
        if (value instanceof Page) {
            Page page = (Page)value;
            value = page.getItems();
        }
        if (fieldType.isArray() && value instanceof Collection) {
            Collection collection = (Collection)value;
            value = Array.newInstance(fieldType.getComponentType(), collection.size());
            int i = 0;
            for (Object object : collection) {
                Array.set(value, i++, object);
            }
        }
        return value;
    }

    private Field _getField(Class<?> entityClass, String fieldName) {
        for (Class<?> clazz = entityClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!Objects.equals(field.getName(), fieldName) && !Objects.equals(field.getName(), "_" + fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    private List<Object> _getItems(Object entity) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (entity instanceof Collection) {
            items.addAll((Collection)entity);
        } else if (entity instanceof Page) {
            Page page = (Page)entity;
            items.addAll(page.getItems());
        } else if (this._isArray(entity)) {
            Collections.addAll(items, (Object[])entity);
        } else {
            items.add(entity);
        }
        return items;
    }

    private UnsafeTriFunction<String, Object, NestedFieldsContext, Object> _getUnsafeTriFunction(String fieldName, Class<?> itemClass, NestedFieldsContext nestedFieldsContext) {
        List parentClasses = ListUtil.fromArray((Object[])new Class[]{Void.class});
        for (Class<?> clazz = itemClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            parentClasses.add(clazz);
        }
        for (Class parentClass : parentClasses) {
            FactoryKey factoryKey = new FactoryKey(fieldName, parentClass, nestedFieldsContext.getResourceVersion());
            UnsafeTriFunction<String, Object, NestedFieldsContext, Object> unsafeTriFunction = this._nestedFieldServiceTrackerCustomizer._unsafeTriFunctions.get(factoryKey);
            if (unsafeTriFunction == null) continue;
            return unsafeTriFunction;
        }
        return null;
    }

    private boolean _isArray(Object object) {
        Class<?> objectClass = object.getClass();
        return objectClass.isArray();
    }

    private void _setFieldValues(Object entity, List<String> nestedFields, NestedFieldsContext nestedFieldsContext) throws Exception {
        List<Object> items = this._getItems(entity);
        for (String nestedField : nestedFields) {
            String childNestedField = null;
            int index = nestedField.indexOf(".");
            if (index != -1) {
                childNestedField = nestedField.substring(index + 1);
                nestedField = nestedField.substring(0, index);
            }
            for (Object item : items) {
                Class<?> itemClass = item.getClass();
                Field field = this._getField(itemClass, nestedField);
                if (field == null) continue;
                field.setAccessible(true);
                UnsafeTriFunction<String, Object, NestedFieldsContext, Object> unsafeTriFunction = this._getUnsafeTriFunction(nestedField, itemClass, nestedFieldsContext);
                if (unsafeTriFunction == null) continue;
                Object value = this._adaptToFieldType(field.getType(), unsafeTriFunction.apply(nestedField, item, nestedFieldsContext));
                field.set(item, value);
                if (childNestedField == null) continue;
                this._setFieldValues(value, Collections.singletonList(childNestedField), nestedFieldsContext);
            }
        }
    }

    protected static class NestedFieldServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, List<FactoryKey>> {
        private static final ObjectMapper _objectMapper = new ObjectMapper();
        private final BundleContext _bundleContext;
        private final Map<FactoryKey, UnsafeTriFunction<String, Object, NestedFieldsContext, Object>> _unsafeTriFunctions = new ConcurrentHashMap<FactoryKey, UnsafeTriFunction<String, Object, NestedFieldsContext, Object>>();

        public List<FactoryKey> addingService(ServiceReference<Object> serviceReference) {
            Object resource = this._bundleContext.getService(serviceReference);
            Class<?> resourceClass = resource.getClass();
            ArrayList<FactoryKey> factoryKeys = null;
            for (Method resourceMethod : resourceClass.getDeclaredMethods()) {
                NestedField nestedField = resourceMethod.getAnnotation(NestedField.class);
                if (nestedField == null) continue;
                Class parentClass = nestedField.parentClass();
                FactoryKey factoryKey = new FactoryKey(nestedField.value(), parentClass, this._getAPIVersion(resourceClass.getSuperclass()));
                ServiceObjects serviceObjects = this._bundleContext.getServiceObjects(serviceReference);
                this._unsafeTriFunctions.put(factoryKey, (fieldName, item, nestedFieldsContext) -> this._getNestedFieldValue((String)fieldName, item, (NestedFieldsContext)nestedFieldsContext, resourceMethod, this._getResourceMethodArgNameTypeEntries(resourceClass, resourceMethod), (ServiceObjects<Object>)serviceObjects));
                if (factoryKeys == null) {
                    factoryKeys = new ArrayList<FactoryKey>();
                }
                factoryKeys.add(factoryKey);
            }
            return factoryKeys;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, List<FactoryKey> factoryKeys) {
        }

        public void removedService(ServiceReference<Object> serviceReference, List<FactoryKey> factoryKeys) {
            factoryKeys.forEach(this._unsafeTriFunctions::remove);
            this._bundleContext.ungetService(serviceReference);
        }

        protected NestedFieldServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        protected HttpServletRequest getHttpServletRequest(Message message) {
            return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
        }

        protected ProviderFactory getProviderFactory(Message message) {
            return ProviderFactory.getInstance((Message)message);
        }

        private Object _convert(String value, Class<?> type) {
            if (value == null) {
                return null;
            }
            return _objectMapper.convertValue((Object)value, type);
        }

        private String _getAPIVersion(Class<?> resourceBaseClass) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = resourceBaseClass.getAnnotations()) {
                if (!(annotation instanceof Path)) continue;
                Path path = (Path)annotation;
                String resourceVersion = path.value();
                return resourceVersion.substring(1);
            }
            return null;
        }

        private <T> Object _getContext(Class<T> contextClass, Message message) {
            if (contextClass.equals(UriInfo.class)) {
                return new UriInfoImpl(message);
            }
            ContextProvider<T> contextProvider = this._getContextProvider(contextClass, message);
            if (contextProvider != null) {
                return contextProvider.createContext(message);
            }
            return null;
        }

        private <T> ContextProvider<T> _getContextProvider(Class<T> contextClass, Message message) {
            ProviderFactory providerFactory = this.getProviderFactory(message);
            return providerFactory.createContextProvider(contextClass, message);
        }

        private Object[] _getMethodArgs(String fieldName, Object item, NestedFieldsContext nestedFieldsContext, Object resource, Method resourceMethod, Map.Entry<String, Class<?>>[] resourceMethodArgNameTypeEntries) throws Exception {
            Object[] args = new Object[resourceMethod.getParameterCount()];
            Message message = this._handleNestedFieldMessage(fieldName, nestedFieldsContext.getMessage(), resource);
            MultivaluedMap pathParameters = nestedFieldsContext.getPathParameters();
            MultivaluedMap queryParameters = nestedFieldsContext.getQueryParameters();
            for (int i = 0; i < resourceMethod.getParameterCount(); ++i) {
                if (resourceMethodArgNameTypeEntries[i] == null) continue;
                args[i] = this._getMethodArgValueFromItem(item, resourceMethodArgNameTypeEntries[i]);
                if (args[i] != null) continue;
                args[i] = this._getMethodArgValueFromRequest(fieldName, message, (MultivaluedMap<String, String>)pathParameters, (MultivaluedMap<String, String>)queryParameters, resourceMethodArgNameTypeEntries[i]);
            }
            this._resetNestedFieldMessage(message);
            return args;
        }

        private Object _getMethodArgValueFromItem(Object item, Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry) throws Exception {
            String argName = resourceMethodArgNameTypeEntry.getKey();
            String methodName = "get" + StringUtil.upperCaseFirstLetter((String)argName);
            ArrayList itemClasses = new ArrayList();
            Class<?> itemClass = item.getClass();
            itemClasses.add(itemClass);
            itemClasses.add(itemClass.getSuperclass());
            for (Class clazz : itemClasses) {
                for (Method method : clazz.getMethods()) {
                    if (!StringUtil.equals((String)method.getName(), (String)methodName) || !Objects.equals(method.getReturnType(), resourceMethodArgNameTypeEntry.getValue()) || method.getParameterCount() != 0) continue;
                    return method.invoke(item, new Object[0]);
                }
            }
            return null;
        }

        private Object _getMethodArgValueFromRequest(String fieldName, Message message, MultivaluedMap<String, String> pathParameters, MultivaluedMap<String, String> queryParameters, Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry) {
            Object argValue = null;
            Class<?> resourceMethodArgType = resourceMethodArgNameTypeEntry.getValue();
            Object context = this._getContext(resourceMethodArgType, message);
            if (context != null) {
                argValue = context;
            } else {
                argValue = this._convert((String)pathParameters.getFirst((Object)resourceMethodArgNameTypeEntry.getKey()), resourceMethodArgType);
                if (argValue == null) {
                    argValue = this._convert((String)queryParameters.getFirst((Object)(fieldName + "." + resourceMethodArgNameTypeEntry.getKey())), resourceMethodArgType);
                }
            }
            return argValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object _getNestedFieldValue(String fieldName, Object item, NestedFieldsContext nestedFieldsContext, Method resourceMethod, Map.Entry<String, Class<?>>[] resourceMethodArgNameTypeEntries, ServiceObjects<Object> serviceObjects) throws Exception {
            Object resource = serviceObjects.getService();
            try {
                this._setResourceContexts(nestedFieldsContext.getMessage(), resource);
                Object[] args = this._getMethodArgs(fieldName, item, nestedFieldsContext, resource, resourceMethod, resourceMethodArgNameTypeEntries);
                Object object = resourceMethod.invoke(resource, args);
                return object;
            }
            finally {
                serviceObjects.ungetService(resource);
            }
        }

        private Map.Entry<String, Class<?>>[] _getResourceMethodArgNameTypeEntries(Class<?> resourceClass, Method resourceMethod) {
            Parameter[] parentParameters;
            Map.Entry[] resourceMethodArgNameTypeEntries;
            Parameter[] resourceMethodParameters;
            block6: {
                resourceMethodParameters = resourceMethod.getParameters();
                resourceMethodArgNameTypeEntries = new Map.Entry[resourceMethodParameters.length];
                parentParameters = null;
                try {
                    Class<?> parentResourceClass = resourceClass.getSuperclass();
                    Method parentResourceMethod = parentResourceClass.getMethod(resourceMethod.getName(), resourceMethod.getParameterTypes());
                    parentParameters = parentResourceMethod.getParameters();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Throwable)noSuchMethodException);
                }
            }
            for (int i = 0; i < resourceMethodParameters.length; ++i) {
                Parameter parameter = resourceMethodParameters[i];
                NestedFieldId nestedFieldId = NestedFieldsWriterInterceptor._getAnnotation(NestedFieldId.class, parameter, parentParameters, i);
                Class<?> parameterType = parameter.getType();
                if (nestedFieldId == null) {
                    QueryParam queryParam;
                    PathParam pathParam;
                    Context context = NestedFieldsWriterInterceptor._getAnnotation(Context.class, parameter, parentParameters, i);
                    if (context != null) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(parameter.getName(), parameterType);
                    }
                    if ((pathParam = NestedFieldsWriterInterceptor._getAnnotation(PathParam.class, parameter, parentParameters, i)) != null) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(pathParam.value(), parameterType);
                    }
                    if ((queryParam = NestedFieldsWriterInterceptor._getAnnotation(QueryParam.class, parameter, parentParameters, i)) == null) continue;
                    resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(queryParam.value(), parameterType);
                    continue;
                }
                resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(nestedFieldId.value(), parameterType);
            }
            return resourceMethodArgNameTypeEntries;
        }

        private Message _handleNestedFieldMessage(String fieldName, Message message, Object resource) {
            message.put((Object)"HTTP.REQUEST", (Object)new NestedFieldsHttpServletRequestWrapper(fieldName, this.getHttpServletRequest(message)));
            message.setExchange((Exchange)new ExchangeWrapper(message.getExchange(), resource));
            return message;
        }

        private void _resetNestedFieldMessage(Message message) {
            NestedFieldsHttpServletRequestWrapper nestedFieldsHttpServletRequestWrapper = (NestedFieldsHttpServletRequestWrapper)((Object)message.getContextualProperty("HTTP.REQUEST"));
            message.put((Object)"HTTP.REQUEST", (Object)nestedFieldsHttpServletRequestWrapper.getRequest());
            Exchange exchange = message.getExchange();
            if (exchange instanceof ExchangeWrapper) {
                ExchangeWrapper exchangeWrapper = (ExchangeWrapper)exchange;
                message.setExchange(exchangeWrapper.getExchange());
            }
        }

        private void _setContextFields(Field[] fields, Message message, Object resource) throws Exception {
            for (Field field : fields) {
                String name = field.getName();
                if (!name.startsWith("context") && field.getAnnotation(Context.class) == null) continue;
                field.setAccessible(true);
                field.set(resource, this._getContext(field.getType(), message));
            }
        }

        private void _setResourceContexts(Message message, Object resource) throws Exception {
            Class<?> resourceClass = resource.getClass();
            this._setContextFields(resourceClass.getDeclaredFields(), message, resource);
            Class<?> superClass = resourceClass.getSuperclass();
            this._setContextFields(superClass.getDeclaredFields(), message, resource);
        }
    }

    private static class FactoryKey {
        private final String _nestedFieldName;
        private final Class<?> _parentClass;
        private final String _resourceVersion;

        public boolean equals(Object object) {
            FactoryKey factoryKey = (FactoryKey)object;
            return Objects.equals(factoryKey._nestedFieldName, this._nestedFieldName) && Objects.equals(factoryKey._parentClass, this._parentClass) && Objects.equals(factoryKey._resourceVersion, this._resourceVersion);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._nestedFieldName);
            hashCode = HashUtil.hash((int)hashCode, this._parentClass);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._resourceVersion);
            return hashCode;
        }

        private FactoryKey(String nestedFieldName, Class<?> parentClass, String resourceVersion) {
            this._nestedFieldName = nestedFieldName;
            this._parentClass = parentClass;
            this._resourceVersion = resourceVersion;
        }
    }

    @FunctionalInterface
    protected static interface UnsafeTriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws Exception;
    }
}

