/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.openapi.contributor;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.action.ActionInfo;
import com.liferay.portal.vulcan.dto.action.DTOActionProvider;
import com.liferay.portal.vulcan.openapi.OpenAPIContext;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import com.liferay.portal.vulcan.util.ActionUtil;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={OpenAPIContributor.class})
public class ActionsOpenAPIContributor
implements OpenAPIContributor {
    private ServiceTrackerMap<String, DTOActionProvider> _serviceTrackerMap;

    public void contribute(OpenAPI openAPI, OpenAPIContext openAPIContext) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-180090")) {
            return;
        }
        Map<String, Schema> individualSchemas = this._getIndividualSchemas(openAPI);
        for (Map.Entry<String, Schema> entry : individualSchemas.entrySet()) {
            DTOActionProvider dtoActionProvider = (DTOActionProvider)this._serviceTrackerMap.getService((Object)entry.getKey());
            if (dtoActionProvider == null) continue;
            Schema schema = entry.getValue();
            Map properties = schema.getProperties();
            final Schema actionsSchema = (Schema)properties.get("actions");
            final HashMap<String, Schema> actionSchemas = new HashMap<String, Schema>();
            Map actionInfos = dtoActionProvider.getActionInfos();
            for (Map.Entry actionInfoEntry : actionInfos.entrySet()) {
                ActionInfo actionInfo = (ActionInfo)actionInfoEntry.getValue();
                if (actionInfo == null || actionInfo.getActionName() == null || actionInfo.getResourceMethodName() == null) continue;
                actionSchemas.put((String)actionInfoEntry.getKey(), this._getActionSchema((String)actionInfoEntry.getKey(), (ActionInfo)actionInfoEntry.getValue(), openAPIContext.getUriInfo()));
            }
            properties.put("actions", new MapSchema(){
                {
                    this.setDescription(actionsSchema.getDescription());
                    this.setProperties(actionSchemas);
                    this.setReadOnly(actionsSchema.getReadOnly());
                }
            });
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DTOActionProvider.class, (String)"dto.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private Schema _getActionSchema(String actionName, ActionInfo actionInfo, UriInfo uriInfo) {
        final Map map = ActionUtil.addAction((String)actionName, (Class)actionInfo.getResourceClass(), null, (String)actionInfo.getResourceMethodName(), (ModelResourcePermission)null, (Long)null, (UriInfo)uriInfo);
        return new MapSchema(){
            {
                this.setProperties(HashMapBuilder.put((Object)"href", (Object)ActionsOpenAPIContributor.this._getStringSchema((String)map.get("href"))).put((Object)"method", (Object)ActionsOpenAPIContributor.this._getStringSchema((String)map.get("method"))).build());
            }
        };
    }

    private Map<String, Schema> _getIndividualSchemas(OpenAPI openAPI) {
        HashMap<String, Schema> individualSchemas = new HashMap<String, Schema>();
        Components components = openAPI.getComponents();
        if (components == null) {
            return individualSchemas;
        }
        Map schemas = components.getSchemas();
        if (schemas == null) {
            return individualSchemas;
        }
        for (Schema schema : schemas.values()) {
            Map properties = schema.getProperties();
            if (properties == null || !properties.containsKey("actions") || !properties.containsKey("x-class-name")) continue;
            Schema xClassNameSchema = (Schema)properties.get("x-class-name");
            individualSchemas.put((String)xClassNameSchema.getDefault(), schema);
        }
        return individualSchemas;
    }

    private Schema _getStringSchema(String defaultValue) {
        StringSchema schema = new StringSchema();
        schema.setDefault((Object)defaultValue);
        return schema;
    }
}

