/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.pagination.provider;

import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.internal.configuration.HeadlessAPICompanyConfiguration;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.pagination.provider.PaginationProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PaginationProvider.class})
public class PaginationProviderImpl
implements PaginationProvider {
    @Reference
    private ConfigurationProvider _configurationProvider;

    public Pagination getPagination(long companyId, Integer page, Integer pageSize) {
        return this._getPagination(this._getPageSizeLimit(companyId), GetterUtil.getInteger((Object)page, (int)1), GetterUtil.getInteger((Object)pageSize, (int)20));
    }

    private int _getPageSizeLimit(long companyId) {
        try {
            HeadlessAPICompanyConfiguration headlessAPICompanyConfiguration = (HeadlessAPICompanyConfiguration)this._configurationProvider.getCompanyConfiguration(HeadlessAPICompanyConfiguration.class, companyId);
            return headlessAPICompanyConfiguration.pageSizeLimit();
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException.getMessage());
        }
    }

    private Pagination _getPagination(int pageSizeLimit, int requestPage, int requestPageSize) {
        if (this._isUnlimited(requestPage) || this._isUnlimited(requestPageSize)) {
            if (this._isUnlimited(pageSizeLimit)) {
                return Pagination.of((int)-1, (int)-1);
            }
            return Pagination.of((int)1, (int)pageSizeLimit);
        }
        if (this._isUnlimited(pageSizeLimit)) {
            return Pagination.of((int)requestPage, (int)requestPageSize);
        }
        return Pagination.of((int)requestPage, (int)Math.min(requestPageSize, pageSizeLimit));
    }

    private boolean _isUnlimited(int value) {
        return value <= 0;
    }
}

