/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.template;

import com.liferay.petra.function.UnsafeSupplierValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.resource.locator.ResourceLocatorFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"type=GLOBAL"}, service={TemplateContextContributor.class})
public class ResourceLocatorTemplateContextContributor
implements TemplateContextContributor {
    private static final Log _log = LogFactoryUtil.getLog(ResourceLocatorTemplateContextContributor.class);
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocatorFactory _resourceLocatorFactory;
    @Reference
    private UserLocalService _userLocalService;

    public void prepare(Map<String, Object> contextObjects, HttpServletRequest httpServletRequest) {
        contextObjects.put("resourceLocator", new UnsafeSupplierValue(() -> {
            try {
                User user = this._portal.getUser(httpServletRequest);
                if (user == null) {
                    user = this._userLocalService.getGuestUser(this._portal.getCompanyId(httpServletRequest));
                }
                return this._resourceLocatorFactory.create(httpServletRequest, user);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return null;
            }
        }));
    }
}

