/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.osgi.service.cm.Configuration;

@Provider
public class ContextContainerRequestFilter
implements ContainerRequestFilter {
    private final Map<String, Configuration> _configurations;
    private final GroupLocalService _groupLocalService;
    private final Language _language;
    private final Portal _portal;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final Object _scopeChecker;
    private final VulcanBatchEngineImportTaskResource _vulcanBatchEngineImportTaskResource;

    public ContextContainerRequestFilter(Map<String, Configuration> configurations, GroupLocalService groupLocalService, Language language, Portal portal, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, Object scopeChecker, VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this._configurations = configurations;
        this._groupLocalService = groupLocalService;
        this._language = language;
        this._portal = portal;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._scopeChecker = scopeChecker;
        this._vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        this.handleMessage(containerRequestContext, PhaseInterceptorChain.getCurrentMessage());
    }

    public void handleMessage(ContainerRequestContext containerRequestContext, Message message) throws Fault {
        try {
            this._handleMessage(containerRequestContext, message);
        }
        catch (Exception exception) {
            throw new Fault((Throwable)exception);
        }
    }

    private void _filterExcludedOperationIds(ContainerRequestContext containerRequestContext, Object instance, Message message) {
        String path = StringUtil.removeSubstring((String)((String)message.get((Object)Message.BASE_PATH)), (String)"/o");
        if (this._configurations.containsKey(path = StringUtil.replaceLast((String)path, (char)'/', (String)""))) {
            Method[] methods;
            Configuration configuration = this._configurations.get(path);
            Dictionary properties = configuration.getProperties();
            String excludedOperationIds = GetterUtil.getString(properties.get("excludedOperationIds"));
            Set excludedOperationIdsList = SetUtil.fromArray((Object[])excludedOperationIds.split(","));
            Class<?> clazz = instance.getClass();
            for (Method method : methods = clazz.getMethods()) {
                if (!excludedOperationIdsList.contains(method.getName())) continue;
                containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Conflict with " + method.getName())).build());
            }
        }
    }

    private void _handleMessage(ContainerRequestContext containerRequestContext, Message message) throws Exception {
        Object instance = ContextProviderUtil.getMatchedResource(message);
        if (instance == null) {
            return;
        }
        HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
        this._filterExcludedOperationIds(containerRequestContext, instance, message);
        Class<?> clazz = instance.getClass();
        Class<?> superClass = clazz.getSuperclass();
        for (Field field : superClass.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.equals(Object.class) && Objects.equals(field.getName(), "contextScopeChecker")) {
                field.setAccessible(true);
                field.set(instance, this._scopeChecker);
                continue;
            }
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, new AcceptLanguageImpl(httpServletRequest, this._language, this._portal));
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getCompany(httpServletRequest));
                continue;
            }
            if (fieldClass.isAssignableFrom(GroupLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._groupLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, message.getContextualProperty("HTTP.RESPONSE"));
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourceActionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourceActionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourcePermissionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourcePermissionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(RoleLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._roleLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, new UriInfoImpl(message));
                continue;
            }
            if (fieldClass.isAssignableFrom(User.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getUser(httpServletRequest));
                continue;
            }
            if (!fieldClass.isAssignableFrom(VulcanBatchEngineImportTaskResource.class)) continue;
            field.setAccessible(true);
            field.set(instance, this._vulcanBatchEngineImportTaskResource);
        }
    }
}

