/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.param.converter.provider;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;

@Provider
public class SiteParamConverterProvider
implements ParamConverter<Long>,
ParamConverterProvider {
    private static final Log _log = LogFactoryUtil.getLog(SiteParamConverterProvider.class);
    @Context
    private Company _company;
    private final DepotEntryLocalService _depotEntryLocalService;
    private final GroupLocalService _groupLocalService;
    @Context
    private UriInfo _uriInfo;

    public SiteParamConverterProvider(DepotEntryLocalService depotEntryLocalService, GroupLocalService groupLocalService) {
        this._depotEntryLocalService = depotEntryLocalService;
        this._groupLocalService = groupLocalService;
    }

    public Long fromString(String parameter) {
        MultivaluedMap multivaluedMap = this._uriInfo.getPathParameters();
        Long siteId = null;
        siteId = multivaluedMap.containsKey((Object)"assetLibraryId") ? this.getDepotGroupId((String)multivaluedMap.getFirst((Object)"assetLibraryId"), this._company.getCompanyId()) : this.getGroupId(this._company.getCompanyId(), (String)multivaluedMap.getFirst((Object)"siteId"));
        if (siteId != null) {
            return siteId;
        }
        StringBundler sb = new StringBundler(4);
        sb.append("Unable to get a valid ");
        if (multivaluedMap.containsKey((Object)"assetLibraryId")) {
            sb.append("asset library");
        } else {
            sb.append("site");
        }
        sb.append(" with ID ");
        sb.append(parameter);
        throw new NotFoundException(sb.toString());
    }

    public <T> ParamConverter<T> getConverter(Class<T> clazz, Type type, Annotation[] annotations) {
        if (Long.class.equals(clazz) && this._hasSiteIdAnnotation(annotations)) {
            return this;
        }
        return null;
    }

    public Long getDepotGroupId(String assetLibraryId, long companyId) {
        if (assetLibraryId == null) {
            return null;
        }
        return this._getDepotGroupId(assetLibraryId, companyId);
    }

    public Long getGroupId(long companyId, String siteId) {
        if (siteId == null) {
            return null;
        }
        return this._getGroupId(companyId, siteId);
    }

    public String toString(Long parameter) {
        return String.valueOf(parameter);
    }

    private boolean _checkGroup(Group group) {
        return this._isDepotOrSite(group) || group != null && this._isDepotOrSite(group.getLiveGroup());
    }

    private Long _getDepotGroupId(String assetLibraryId, long companyId) {
        Group group = this._groupLocalService.fetchGroup(companyId, assetLibraryId);
        if (group == null) {
            try {
                DepotEntry depotEntry = this._depotEntryLocalService.fetchDepotEntry(GetterUtil.getLong((String)assetLibraryId));
                if (depotEntry == null) {
                    return null;
                }
                group = depotEntry.getGroup();
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
                return null;
            }
        }
        if (this._checkGroup(group)) {
            return group.getGroupId();
        }
        return null;
    }

    private Long _getGroupId(long companyId, String groupKey) {
        Group group = this._groupLocalService.fetchGroup(companyId, groupKey);
        if (group == null) {
            group = this._groupLocalService.fetchGroup(GetterUtil.getLong((String)groupKey));
        }
        if (this._checkGroup(group)) {
            return group.getGroupId();
        }
        return null;
    }

    private boolean _hasSiteIdAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String annotationString = annotation.toString();
            if (!annotationString.equals("@javax.ws.rs.PathParam(value=assetLibraryId)") && !annotationString.equals("@javax.ws.rs.PathParam(value=siteId)")) continue;
            return true;
        }
        return false;
    }

    private boolean _isDepotOrSite(Group group) {
        return group != null && (group.isDepot() || group.isSite());
    }
}

