/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.resource;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.vulcan.openapi.DTOProperty;
import com.liferay.portal.vulcan.openapi.OpenAPISchemaFilter;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.GenericOpenApiContext;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.integration.api.OpenApiScanner;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;

@Component(service={OpenAPIResource.class})
public class OpenAPIResourceImpl
implements OpenAPIResource {
    public Response getOpenAPI(OpenAPISchemaFilter openAPISchemaFilter, final Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        JaxrsOpenApiContextBuilder jaxrsOpenApiContextBuilder = new JaxrsOpenApiContextBuilder();
        OpenApiContext openApiContext = jaxrsOpenApiContextBuilder.buildContext(true);
        GenericOpenApiContext genericOpenApiContext = (GenericOpenApiContext)openApiContext;
        genericOpenApiContext.setCacheTTL(0L);
        genericOpenApiContext.setOpenApiScanner(new OpenApiScanner(){

            public Set<Class<?>> classes() {
                return resourceClasses;
            }

            public Map<String, Object> resources() {
                return new HashMap<String, Object>();
            }

            public void setConfiguration(OpenAPIConfiguration openAPIConfiguration) {
            }
        });
        OpenAPI openAPI = openApiContext.read();
        if (openAPISchemaFilter != null) {
            SpecFilter specFilter = new SpecFilter();
            openAPI = specFilter.filter(openAPI, this._toOpenAPISpecFilter(openAPISchemaFilter), (Map)uriInfo.getQueryParameters(), null, null);
        }
        if (openAPI == null) {
            return Response.status((int)404).build();
        }
        if (uriInfo != null) {
            Server server = new Server();
            server.setUrl(UriInfoUtil.getBasePath((UriInfo)uriInfo));
            openAPI.setServers(Collections.singletonList(server));
        }
        if (StringUtil.equalsIgnoreCase((String)"yaml", (String)type)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Yaml.pretty((Object)openAPI)).type("application/yaml").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)openAPI).type(javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Response getOpenAPI(Set<Class<?>> resourceClasses, String type) throws Exception {
        return this.getOpenAPI(resourceClasses, type, null);
    }

    public Response getOpenAPI(Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        return this.getOpenAPI(null, resourceClasses, type, uriInfo);
    }

    private OpenAPISpecFilter _toOpenAPISpecFilter(final OpenAPISchemaFilter openAPISchemaFilter) {
        final Map schemaMappings = openAPISchemaFilter.getSchemaMappings();
        return new AbstractSpecFilter(){

            public Optional<OpenAPI> filterOpenAPI(OpenAPI openAPI, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                Components components = openAPI.getComponents();
                Map schemas = components.getSchemas();
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    String key = (String)entry.getKey();
                    Schema schema = (Schema)schemas.get(key);
                    schemas.put(schemaMappings.get(key), schema);
                    schemas.remove(key);
                    this._replaceParameters(key, openAPI.getPaths());
                }
                return super.filterOpenAPI(openAPI, params, cookies, headers);
            }

            public Optional<Operation> filterOperation(Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                String operationId = operation.getOperationId();
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    operationId = StringUtil.replace((String)operationId, (String)TextFormatter.formatPlural((String)((String)entry.getKey())), (String)TextFormatter.formatPlural((String)((String)entry.getValue())));
                    operationId = StringUtil.replace((String)operationId, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
                }
                operation.setOperationId(operationId);
                List tags = operation.getTags();
                if (tags != null) {
                    ArrayList newTags = new ArrayList(tags);
                    for (Map.Entry entry : schemaMappings.entrySet()) {
                        for (int i = 0; i < newTags.size(); ++i) {
                            if (!Objects.equals(entry.getKey(), newTags.get(i))) continue;
                            newTags.set(i, entry.getValue());
                        }
                    }
                    operation.setTags(newTags);
                }
                return super.filterOperation(operation, apiDescription, params, cookies, headers);
            }

            public Optional<Parameter> filterParameter(Parameter parameter, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    String schemaName;
                    String parameterName = parameter.getName();
                    if (!parameterName.contains(schemaName = StringUtil.lowerCaseFirstLetter((String)((String)entry.getKey())))) continue;
                    parameter.setName(StringUtil.replace((String)parameterName, (String)schemaName, (String)StringUtil.lowerCaseFirstLetter((String)((String)entry.getValue()))));
                }
                return super.filterParameter(parameter, operation, apiDescription, params, cookies, headers);
            }

            public Optional<RequestBody> filterRequestBody(RequestBody requestBody, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                this._replaceContentReference(requestBody.getContent());
                return super.filterRequestBody(requestBody, operation, apiDescription, params, cookies, headers);
            }

            public Optional<ApiResponse> filterResponse(ApiResponse response, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                this._replaceContentReference(response.getContent());
                return super.filterResponse(response, operation, apiDescription, params, cookies, headers);
            }

            public Optional<Schema> filterSchema(Schema schema, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                DTOProperty dtoProperty = openAPISchemaFilter.getDTOProperty();
                if (Objects.equals(dtoProperty.getName(), schema.getName())) {
                    for (DTOProperty childDTOProperty : dtoProperty.getDTOProperties()) {
                        schema.addProperties(childDTOProperty.getName(), this._addSchema(childDTOProperty));
                    }
                    return Optional.of(schema);
                }
                return super.filterSchema(schema, params, cookies, headers);
            }

            public Optional<Schema> filterSchemaProperty(Schema propertySchema, Schema schema, String propName, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                for (Map.Entry<String, String> entry : schemaMappings.entrySet()) {
                    this._replaceReference(entry, propertySchema);
                    if (!(propertySchema instanceof ArraySchema)) continue;
                    ArraySchema arraySchema = (ArraySchema)propertySchema;
                    this._replaceReference(entry, arraySchema.getItems());
                }
                return super.filterSchemaProperty(propertySchema, schema, propName, params, cookies, headers);
            }

            private Schema<Object> _addSchema(DTOProperty dtoProperty) {
                Schema schema = new Schema();
                schema.setName(dtoProperty.getName());
                String type = dtoProperty.getType();
                if (type.equals("Boolean")) {
                    schema.setType("boolean");
                } else if (type.equals("Date")) {
                    schema.setFormat("date");
                    schema.setType("string");
                } else if (type.equals("Double")) {
                    schema.setFormat("double");
                    schema.setType("number");
                } else if (type.equals("Integer")) {
                    schema.setFormat("int32");
                    schema.setType("integer");
                } else if (type.equals("Long")) {
                    schema.setFormat("int64");
                    schema.setType("integer");
                } else if (type.equals("String")) {
                    schema.setType("string");
                } else {
                    schema.setType("object");
                }
                for (DTOProperty childDTOProperty : dtoProperty.getDTOProperties()) {
                    schema.addProperties(childDTOProperty.getName(), this._addSchema(childDTOProperty));
                }
                return schema;
            }

            private void _replaceContentReference(Content content) {
                if (content == null) {
                    return;
                }
                for (MediaType mediaType : content.values()) {
                    for (Map.Entry<String, String> entry : schemaMappings.entrySet()) {
                        if (mediaType.getSchema() == null) continue;
                        this._replaceReference(entry, mediaType.getSchema());
                    }
                }
            }

            private void _replaceParameters(String key, Paths paths) {
                String parameterName = StringUtil.lowerCaseFirstLetter((String)key);
                for (String path : new ArrayList(paths.keySet())) {
                    if (!path.contains(parameterName)) continue;
                    PathItem pathItem = (PathItem)paths.get((Object)path);
                    paths.put((Object)path.replace(parameterName, StringUtil.lowerCaseFirstLetter((String)((String)schemaMappings.get(key)))), (Object)pathItem);
                    paths.remove((Object)path);
                }
            }

            private void _replaceReference(Map.Entry<String, String> entry, Schema schema) {
                String ref = schema.get$ref();
                if (ref == null || !ref.contains(entry.getKey())) {
                    return;
                }
                schema.set$ref(StringUtil.replace((String)ref, (String)entry.getKey(), (String)entry.getValue()));
            }
        };
    }
}

