/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.web.internal;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.io.AnnotatedObjectInputStream;
import com.liferay.petra.io.AnnotatedObjectOutputStream;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.servlet.PortalSessionListener;
import com.liferay.portal.servlet.filters.healthcheckdatasource.HealthCheckDataSourceFilter;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.web.internal.session.replication.SessionReplicationFilter;
import com.liferay.shielded.container.Ordered;
import com.liferay.shielded.container.ShieldedContainerInitializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Ordered(value=2)
public class PortalWebShieldedContainerInitializer
implements ShieldedContainerInitializer {
    public void initialize(ServletContext servletContext) throws ServletException {
        FilterRegistration.Dynamic dynamic;
        if (PropsValues.PORTLET_SESSION_REPLICATE_ENABLED && ServerDetector.isTomcat()) {
            DependencyManagerSyncUtil.registerSyncCallable(() -> {
                Class<?> clazz = Class.forName("com.liferay.support.tomcat.session.LiferayDeltaManager", true, ServletContext.class.getClassLoader());
                Method initMethod = clazz.getMethod("init", Function.class, Function.class);
                initMethod.invoke(null, new Function<InputStream, ObjectInputStream>(){

                    @Override
                    public ObjectInputStream apply(InputStream inputStream) {
                        try {
                            return new AnnotatedObjectInputStream(inputStream);
                        }
                        catch (IOException ioException) {
                            throw new RuntimeException(ioException);
                        }
                    }
                }, new Function<OutputStream, ObjectOutputStream>(){

                    @Override
                    public ObjectOutputStream apply(OutputStream outputStream) {
                        try {
                            return new AnnotatedObjectOutputStream(outputStream);
                        }
                        catch (IOException ioException) {
                            throw new RuntimeException(ioException);
                        }
                    }
                });
                return null;
            });
        } else if (PropsValues.PORTLET_SESSION_REPLICATE_ENABLED) {
            dynamic = servletContext.addFilter(SessionReplicationFilter.class.getName(), (Filter)new SessionReplicationFilter());
            dynamic.setAsyncSupported(true);
            dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        }
        if (PropsValues.HEALTH_CHECK_DATA_SOURCE_ENABLED) {
            dynamic = servletContext.addFilter(HealthCheckDataSourceFilter.class.getName(), (Filter)new HealthCheckDataSourceFilter());
            dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/health_check/data_source"});
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try (InputStream inputStream = servletContext.getResourceAsStream("/WEB-INF/shielded-container-web.xml");){
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element rootElement = document.getDocumentElement();
            HashMap filterMappingMap = new HashMap();
            this._forEachChildElement(rootElement, "filter-mapping", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)filerMappingElement -> filterMappingMap.put(this._getChildText((Node)filerMappingElement, "filter-name"), filerMappingElement)));
            this._forEachChildElement(rootElement, "filter", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)filterElement -> {
                String filterName = this._getChildText((Node)filterElement, "filter-name");
                FilterRegistration.Dynamic dynamic = servletContext.addFilter(filterName, this._getChildText((Node)filterElement, "filter-class"));
                dynamic.setAsyncSupported(GetterUtil.getBoolean((String)this._getChildText((Node)filterElement, "async-supported")));
                this._forEachChildElement((Element)filterElement, "init-param", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)initParamElement -> dynamic.setInitParameter(this._getChildText((Node)initParamElement, "param-name"), this._getChildText((Node)initParamElement, "param-value"))));
                Element filterMappingElement = (Element)filterMappingMap.get(filterName);
                if (filterMappingElement != null) {
                    dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.valueOf((String)this._getChildText(filterMappingElement, "dispatcher"))), false, new String[]{this._getChildText(filterMappingElement, "url-pattern")});
                }
            }));
            this._forEachChildElement(rootElement, "listener-class", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)listenerClassElement -> servletContext.addListener(listenerClassElement.getTextContent())));
            if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
                servletContext.addListener(SerializableSessionAttributeListener.class);
            }
            servletContext.addListener(PortalSessionListener.class);
            servletContext.addListener(PortletSessionListenerManager.class);
            HashMap servletMappingMap = new HashMap();
            this._forEachChildElement(rootElement, "servlet-mapping", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)servletMappingElement -> {
                List urlPatterns = servletMappingMap.computeIfAbsent(this._getChildText((Node)servletMappingElement, "servlet-name"), servletName -> new ArrayList());
                urlPatterns.add(this._getChildText((Node)servletMappingElement, "url-pattern"));
            }));
            HashSet portalServletURLPatterns = new HashSet();
            for (List urlPatterns : servletMappingMap.values()) {
                portalServletURLPatterns.addAll(urlPatterns);
            }
            servletContext.setAttribute("PORTAL_SERVLET_URL_PATTERNS", Collections.unmodifiableSet(portalServletURLPatterns));
            this._forEachChildElement(rootElement, "servlet", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)servletElement -> {
                String servletName = this._getChildText((Node)servletElement, "servlet-name");
                ServletRegistration.Dynamic dynamic = servletContext.addServlet(servletName, this._getChildText((Node)servletElement, "servlet-class"));
                String loadOnStartup = this._getChildText((Node)servletElement, "load-on-startup");
                if (loadOnStartup != null) {
                    dynamic.setLoadOnStartup(GetterUtil.getInteger((String)loadOnStartup));
                }
                dynamic.setAsyncSupported(GetterUtil.getBoolean((String)this._getChildText((Node)servletElement, "async-supported")));
                this._forEachChildElement((Element)servletElement, "init-param", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)initParamElement -> dynamic.setInitParameter(this._getChildText((Node)initParamElement, "param-name"), this._getChildText((Node)initParamElement, "param-value"))));
                this._forEachChildElement((Element)servletElement, "multipart-config", (UnsafeConsumer<Element, Exception>)((UnsafeConsumer)multipartConfigElement -> dynamic.setMultipartConfig(new MultipartConfigElement(this._getChildText((Node)multipartConfigElement, "location"), GetterUtil.getLong((String)this._getChildText((Node)multipartConfigElement, "max-file-size")), GetterUtil.getLong((String)this._getChildText((Node)multipartConfigElement, "max-request-size")), GetterUtil.getInteger((String)this._getChildText((Node)multipartConfigElement, "file-size-threshold"))))));
                List urlPatterns = (List)servletMappingMap.get(servletName);
                if (urlPatterns != null) {
                    dynamic.addMapping(urlPatterns.toArray(new String[0]));
                }
            }));
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private void _forEachChildElement(Element parentElement, String childTagName, UnsafeConsumer<Element, Exception> childElementConsumer) throws Exception {
        NodeList childNodeList = parentElement.getElementsByTagName(childTagName);
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            childElementConsumer.accept((Object)((Element)childNode));
        }
    }

    private String _getChildText(Node node, String childTagName) {
        Element element = (Element)node;
        NodeList childrenNodeList = element.getElementsByTagName(childTagName);
        if (childrenNodeList.getLength() == 0) {
            return null;
        }
        Node childNode = childrenNodeList.item(0);
        return childNode.getTextContent();
    }
}

