/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.web.internal.session.replication;

import com.liferay.petra.io.Deserializer;
import com.liferay.petra.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.util.TransientValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public class SessionReplicationHttpSessionWrapper
extends HttpSessionWrapper {
    private static final String _SCRUBBED_NAMES_NAME = SessionReplicationHttpSessionWrapper.class.getName() + "._SCRUBBED_NAMES_NAME";
    private static final String _TRANSIENT_VALUE_PREFIX = "TRANSIENT_VALUE_";
    private static final Log _log = LogFactoryUtil.getLog(SessionReplicationHttpSessionWrapper.class);
    private static final Set<ClassLoader> _safeClassLoaders = new HashSet<ClassLoader>(Arrays.asList(String.class.getClassLoader(), HttpSession.class.getClassLoader(), Logger.class.getClassLoader()));
    private final Map<String, TransientValue<?>> _transientValues = new ConcurrentHashMap();

    public SessionReplicationHttpSessionWrapper(HttpSession httpSession) {
        super(httpSession);
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        Set scrubbedNames = (Set)super.getAttribute(_SCRUBBED_NAMES_NAME);
        if (value == null || scrubbedNames == null || !scrubbedNames.contains(name)) {
            return value;
        }
        if (value instanceof String) {
            return this._transientValues.get(value);
        }
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap((byte[])value));
        try {
            return deserializer.readObject();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to deserialize object", (Throwable)exception);
            return null;
        }
    }

    public void removeAttribute(String name) {
        String string;
        Object value;
        if (!this._transientValues.isEmpty() && (value = super.getAttribute(name)) instanceof String && (string = (String)value).startsWith(_TRANSIENT_VALUE_PREFIX)) {
            this._transientValues.remove((String)value);
        }
        super.removeAttribute(name);
        Set scrubbedNames = (Set)super.getAttribute(_SCRUBBED_NAMES_NAME);
        if (scrubbedNames != null) {
            scrubbedNames.remove(name);
            super.setAttribute(_SCRUBBED_NAMES_NAME, (Object)scrubbedNames);
        }
    }

    public void setAttribute(String name, Object value) {
        Class<?> clazz;
        Object originalValue = value;
        if (value instanceof TransientValue) {
            TransientValue transientValue = (TransientValue)value;
            if (transientValue.isNull()) {
                value = null;
            } else {
                value = _TRANSIENT_VALUE_PREFIX + value;
                this._transientValues.put((String)value, transientValue);
            }
        } else if (value instanceof Serializable && !_safeClassLoaders.contains((clazz = value.getClass()).getClassLoader())) {
            Serializer serializer = new Serializer();
            serializer.writeObject((Serializable)value);
            ByteBuffer byteBuffer = serializer.toByteBuffer();
            value = byteBuffer.array();
        }
        if (originalValue != value) {
            Set scrubbedNames = (Set)super.getAttribute(_SCRUBBED_NAMES_NAME);
            if (scrubbedNames == null) {
                scrubbedNames = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            scrubbedNames.add(name);
            super.setAttribute(_SCRUBBED_NAMES_NAME, scrubbedNames);
        }
        super.setAttribute(name, value);
    }
}

