/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.util.comparator;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;

public class KaleoDefinitionVersionActiveComparator
extends OrderByComparator<KaleoDefinitionVersion> {
    private static final Log _log = LogFactoryUtil.getLog(KaleoDefinitionVersionActiveComparator.class);
    private final boolean _ascending;

    public KaleoDefinitionVersionActiveComparator() {
        this(false);
    }

    public KaleoDefinitionVersionActiveComparator(boolean ascending) {
        this._ascending = ascending;
    }

    public int compare(KaleoDefinitionVersion kaleoDefinitionVersion1, KaleoDefinitionVersion kaleoDefinitionVersion2) {
        int value = Boolean.compare(this._isActive(kaleoDefinitionVersion1), this._isActive(kaleoDefinitionVersion2));
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private boolean _isActive(KaleoDefinitionVersion kaleoDefinitionVersion) {
        try {
            KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
            return kaleoDefinition.isActive();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return false;
        }
    }
}

