/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ActionType;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.Objects;

public abstract class Action {
    private final ActionType _actionType;
    private final String _description;
    private final ExecutionType _executionType;
    private final String _name;
    private final int _priority;

    public Action(ActionType actionType, String name, String description, String executionType, int priority) throws KaleoDefinitionValidationException {
        this._actionType = actionType;
        this._name = name;
        this._description = description;
        this._executionType = Validator.isNotNull((String)executionType) ? ExecutionType.parse(executionType) : ExecutionType.ON_TIMER;
        this._priority = priority;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Action)) {
            return false;
        }
        Action action = (Action)object;
        if (Objects.equals(this._name, action._name)) {
            return true;
        }
        return true;
    }

    public ActionType getActionType() {
        return this._actionType;
    }

    public String getDescription() {
        return this._description;
    }

    public ExecutionType getExecutionType() {
        return this._executionType;
    }

    public String getName() {
        return this._name;
    }

    public int getPriority() {
        return this._priority;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

