/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.Objects;

public enum RecipientType {
    ADDRESS("address"),
    ASSIGNEES("assignees"),
    ROLE(Role.class.getName()),
    SCRIPT("script"),
    USER(User.class.getName());

    private final String _value;

    public static RecipientType parse(String value) throws KaleoDefinitionValidationException {
        if (Objects.equals(ADDRESS.getValue(), value)) {
            return ADDRESS;
        }
        if (Objects.equals(ASSIGNEES.getValue(), value)) {
            return ASSIGNEES;
        }
        if (Objects.equals(ROLE.getValue(), value)) {
            return ROLE;
        }
        if (Objects.equals(SCRIPT.getValue(), value)) {
            return SCRIPT;
        }
        if (Objects.equals(USER.getValue(), value)) {
            return USER;
        }
        throw new KaleoDefinitionValidationException.InvalidRecipientType(value);
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this._value;
    }

    private RecipientType(String value) {
        this._value = value;
    }
}

