/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.workflow.kaleo.definition.Fork;
import com.liferay.portal.workflow.kaleo.definition.Join;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Definition {
    private final String _content;
    private final String _description;
    private final List<Fork> _forks = new ArrayList<Fork>();
    private State _initialState;
    private final List<Join> _joins = new ArrayList<Join>();
    private final String _name;
    private final Map<String, Node> _nodesMap = new HashMap<String, Node>();
    private List<State> _terminalStates;
    private final int _version;

    public Definition(String name, String description, String content, int version) {
        this._name = name;
        this._description = description;
        this._content = content;
        this._version = version;
    }

    public void addNode(Node node) throws KaleoDefinitionValidationException {
        if (this._nodesMap.containsKey(node.getName())) {
            throw new KaleoDefinitionValidationException.DuplicateNode(node.getDefaultLabel());
        }
        this._nodesMap.put(node.getName(), node);
        if (node instanceof State) {
            State state = (State)node;
            if (state.isInitial()) {
                this._initialState = state;
            }
        } else if (node instanceof Fork) {
            this._forks.add((Fork)node);
        } else if (node instanceof Join) {
            this._joins.add((Join)node);
        }
    }

    public String getContent() {
        return this._content;
    }

    public String getDescription() {
        return this._description;
    }

    public List<Fork> getForks() {
        return Collections.unmodifiableList(this._forks);
    }

    public int getForksCount() {
        return this._forks.size();
    }

    public State getInitialState() {
        return this._initialState;
    }

    public List<Join> getJoins() {
        return Collections.unmodifiableList(this._joins);
    }

    public int getJoinsCount() {
        return this._joins.size();
    }

    public String getName() {
        return this._name;
    }

    public Node getNode(String name) {
        return this._nodesMap.get(name);
    }

    public Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this._nodesMap.values());
    }

    public List<State> getTerminalStates() {
        if (this._terminalStates == null) {
            this._terminalStates = new ArrayList<State>();
            for (Node node : this._nodesMap.values()) {
                State state;
                if (!(node instanceof State) || !(state = (State)node).isTerminal()) continue;
                this._terminalStates.add(state);
            }
        }
        return Collections.unmodifiableList(this._terminalStates);
    }

    public int getVersion() {
        return this._version;
    }

    public boolean hasNode(String name) {
        return this._nodesMap.containsKey(name);
    }
}

