/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.Objects;

public enum ExecutionType {
    ON_ASSIGNMENT("onAssignment"),
    ON_ENTRY("onEntry"),
    ON_EXIT("onExit"),
    ON_TIMER("onTimer");

    private final String _value;

    public static ExecutionType parse(String value) throws KaleoDefinitionValidationException {
        if (Objects.equals(ON_ASSIGNMENT.getValue(), value)) {
            return ON_ASSIGNMENT;
        }
        if (Objects.equals(ON_ENTRY.getValue(), value)) {
            return ON_ENTRY;
        }
        if (Objects.equals(ON_EXIT.getValue(), value)) {
            return ON_EXIT;
        }
        if (Objects.equals(ON_TIMER.getValue(), value)) {
            return ON_TIMER;
        }
        throw new KaleoDefinitionValidationException.InvalidExecutionType(value);
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this._value;
    }

    private ExecutionType(String value) {
        this._value = value;
    }
}

