/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ScriptLanguage {
    public static final ScriptLanguage DRL = new ScriptingLanguageImpl("drl");
    public static final ScriptLanguage GROOVY = new ScriptingLanguageImpl("groovy");
    public static final ScriptLanguage JAVA = new ScriptingLanguageImpl("java");
    public static final Pattern functionPattern = Pattern.compile("^function#[a-z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*$");

    public static ScriptLanguage parse(String value) throws KaleoDefinitionValidationException {
        if (Objects.equals(DRL.getValue(), value)) {
            return DRL;
        }
        if (Objects.equals(GROOVY.getValue(), value)) {
            return GROOVY;
        }
        if (Objects.equals(JAVA.getValue(), value)) {
            return JAVA;
        }
        Matcher matcher = functionPattern.matcher(value);
        if (matcher.matches()) {
            return new ScriptingLanguageImpl(value);
        }
        throw new KaleoDefinitionValidationException.InvalidScriptLanguage(value);
    }

    public String getValue();

    public static final class ScriptingLanguageImpl
    implements ScriptLanguage {
        private final String _value;

        public ScriptingLanguageImpl(String value) {
            this._value = value;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }
    }
}

