/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.exception;

import com.liferay.portal.kernel.workflow.WorkflowException;

public class KaleoDefinitionValidationException
extends WorkflowException {
    public KaleoDefinitionValidationException() {
    }

    public KaleoDefinitionValidationException(String msg) {
        super(msg);
    }

    public KaleoDefinitionValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public KaleoDefinitionValidationException(Throwable throwable) {
        super(throwable);
    }

    public static class UnbalancedForkAndJoinNodes
    extends KaleoDefinitionValidationException {
        public UnbalancedForkAndJoinNodes() {
            super("Each fork node requires a join node. Make sure all forks and joins are properly paired");
        }
    }

    public static class UnbalancedForkAndJoinNode
    extends KaleoDefinitionValidationException {
        private final String _fork;
        private final String _join;

        public UnbalancedForkAndJoinNode(String fork, String join) {
            super(String.format("Fix the errors between the fork node %s and join node %s", fork, join));
            this._fork = fork;
            this._join = join;
        }

        public String getFork() {
            return this._fork;
        }

        public String getJoin() {
            return this._join;
        }
    }

    public static class NotAllowedScriptLanguage
    extends KaleoDefinitionValidationException {
        public NotAllowedScriptLanguage(String msg) {
            super(msg);
        }
    }

    public static class MustSetValidNodeNameLength
    extends KaleoDefinitionValidationException {
        private final int _length;
        private final String _node;

        public MustSetValidNodeNameLength(int length, String node) {
            super(String.format("The %s node name exceeds the length limit of %s characters", node, length));
            this._length = length;
            this._node = node;
        }

        public int getLength() {
            return this._length;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetTerminalStateNode
    extends KaleoDefinitionValidationException {
        public MustSetTerminalStateNode() {
            super("You must define an end node");
        }
    }

    public static class MustSetTaskFormDefinitionOrReference
    extends KaleoDefinitionValidationException {
        private final String _task;
        private final String _taskForm;

        public MustSetTaskFormDefinitionOrReference(String task, String taskForm) {
            super(String.format("The task form %s for task %s must specify a form reference or form definition", taskForm, task));
            this._task = task;
            this._taskForm = taskForm;
        }

        public String getTask() {
            return this._task;
        }

        public String getTaskForm() {
            return this._taskForm;
        }
    }

    public static class MustSetTargetNode
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetTargetNode(String node) {
            super(String.format("The %s transition must end at a node", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetSourceNode
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetSourceNode(String node) {
            super(String.format("The %s transition must have a source node", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetOutgoingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetOutgoingTransition(String node) {
            super(String.format("The %s node must have an outgoing transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetMultipleOutgoingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetMultipleOutgoingTransition(String node) {
            super(String.format("The %s node must have at least 2 outgoing transitions", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetJoinNode
    extends KaleoDefinitionValidationException {
        private final String _fork;

        public MustSetJoinNode(String fork) {
            super(String.format("The %s fork node must have a matching join node", fork));
            this._fork = fork;
        }

        public String getFork() {
            return this._fork;
        }
    }

    public static class MustSetInitialStateNode
    extends KaleoDefinitionValidationException {
        public MustSetInitialStateNode() {
            super("You must define a start node");
        }
    }

    public static class MustSetIncomingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetIncomingTransition(String node) {
            super(String.format("The %s node must have an incoming transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetAssignments
    extends KaleoDefinitionValidationException {
        private final String _task;

        public MustSetAssignments(String task) {
            super(String.format("Specify at least one assignment for the %s task node", task));
            this._task = task;
        }

        public String getTask() {
            return this._task;
        }
    }

    public static class MustPairedForkAndJoinNodes
    extends KaleoDefinitionValidationException {
        private final String _fork;
        private final String _node;

        public MustPairedForkAndJoinNodes(String fork, String node) {
            super(String.format("Fork %s and join %s nodes must be paired", fork, node));
            this._fork = fork;
            this._node = node;
        }

        public String getFork() {
            return this._fork;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustNotSetMoreThanOneDefaultTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustNotSetMoreThanOneDefaultTransition(String node) {
            super(String.format("The %s node cannot have more than one default transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustNotSetIncomingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustNotSetIncomingTransition(String node) {
            super(String.format("The %s node cannot have an incoming transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MultipleInitialStateNodes
    extends KaleoDefinitionValidationException {
        private final String _state1;
        private final String _state2;

        public MultipleInitialStateNodes(String state1, String state2) {
            super(String.format("The workflow has too many start nodes (state nodes %s and %s)", state1, state2));
            this._state1 = state1;
            this._state2 = state2;
        }

        public String getState1() {
            return this._state1;
        }

        public String getState2() {
            return this._state2;
        }
    }

    public static class InvalidTemplateLanguage
    extends KaleoDefinitionValidationException {
        private final String _templateLanguage;

        public InvalidTemplateLanguage(String templateLanguage) {
            super(String.format("Invalid template language %s", templateLanguage));
            this._templateLanguage = templateLanguage;
        }

        public String getTemplateLanguage() {
            return this._templateLanguage;
        }
    }

    public static class InvalidScriptLanguage
    extends KaleoDefinitionValidationException {
        private final String _scriptLanguage;

        public InvalidScriptLanguage(String scriptLanguage) {
            super(String.format("Invalid script language %s", scriptLanguage));
            this._scriptLanguage = scriptLanguage;
        }

        public String getScriptLanguage() {
            return this._scriptLanguage;
        }
    }

    public static class InvalidRecipientType
    extends KaleoDefinitionValidationException {
        private final String _recipientType;

        public InvalidRecipientType(String recipientType) {
            super(String.format("Invalid recipient type %s", recipientType));
            this._recipientType = recipientType;
        }

        public String getRecipientType() {
            return this._recipientType;
        }
    }

    public static class InvalidNotificationType
    extends KaleoDefinitionValidationException {
        private final String _notificationType;

        public InvalidNotificationType(String notificationType) {
            super(String.format("Invalid notification type %s", notificationType));
            this._notificationType = notificationType;
        }

        public String getNotificationType() {
            return this._notificationType;
        }
    }

    public static class InvalidNodeType
    extends KaleoDefinitionValidationException {
        private final String _nodeType;

        public InvalidNodeType(String nodeType) {
            super(String.format("Invalid node type %s", nodeType));
            this._nodeType = nodeType;
        }

        public String getNodeType() {
            return this._nodeType;
        }
    }

    public static class InvalidExecutionType
    extends KaleoDefinitionValidationException {
        private final String _executionType;

        public InvalidExecutionType(String executionType) {
            super(String.format("Invalid execution type %s", executionType));
            this._executionType = executionType;
        }

        public String getExecutionType() {
            return this._executionType;
        }
    }

    public static class InvalidDurationScale
    extends KaleoDefinitionValidationException {
        private final String _durationScale;

        public InvalidDurationScale(String durationScale) {
            super(String.format("Invalid duration scale %s", durationScale));
            this._durationScale = durationScale;
        }

        public String getDurationScale() {
            return this._durationScale;
        }
    }

    public static class EmptyNotificationTemplate
    extends KaleoDefinitionValidationException {
        private final String _node;

        public EmptyNotificationTemplate(String node) {
            super(String.format("The %s node has a empty notification template", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class DuplicateNode
    extends KaleoDefinitionValidationException {
        private final String _node;

        public DuplicateNode(String node) {
            super(String.format("Duplicate node %s", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }
}

