/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.ActionAware;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationAware;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class Node
implements ActionAware,
NotificationAware {
    private Set<Action> _actions;
    private final String _description;
    private final Set<Transition> _incomingTransitions = new LinkedHashSet<Transition>();
    private Map<Locale, String> _labelMap;
    private String _metadata;
    private final String _name;
    private final NodeType _nodeType;
    private Set<Notification> _notifications;
    private final Map<String, Transition> _outgoingTransitions = new LinkedHashMap<String, Transition>();
    private Set<Timer> _timers;

    public Node(NodeType nodeType, String name, String description) {
        this._nodeType = nodeType;
        this._name = name;
        this._description = description;
    }

    public void addIncomingTransition(Transition transition) {
        this._incomingTransitions.add(transition);
    }

    public void addOutgoingTransition(Transition transition) {
        this._outgoingTransitions.put(transition.getName(), transition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        Node node = (Node)object;
        return Objects.equals(this._name, node._name);
    }

    @Override
    public Set<Action> getActions() {
        if (this._actions == null) {
            return Collections.emptySet();
        }
        return this._actions;
    }

    public String getDefaultLabel() {
        if (this._labelMap.isEmpty()) {
            return this._name;
        }
        return this._labelMap.get(LocaleUtil.getDefault());
    }

    public String getDescription() {
        return this._description;
    }

    public Set<Transition> getIncomingTransitions() {
        return this._incomingTransitions;
    }

    public int getIncomingTransitionsCount() {
        return this._incomingTransitions.size();
    }

    public Map<Locale, String> getLabelMap() {
        return this._labelMap;
    }

    public String getMetadata() {
        return this._metadata;
    }

    public String getName() {
        return this._name;
    }

    public NodeType getNodeType() {
        return this._nodeType;
    }

    @Override
    public Set<Notification> getNotifications() {
        if (this._notifications == null) {
            return Collections.emptySet();
        }
        return this._notifications;
    }

    public Map<String, Transition> getOutgoingTransitions() {
        return this._outgoingTransitions;
    }

    public int getOutgoingTransitionsCount() {
        return this._outgoingTransitions.size();
    }

    public List<Transition> getOutgoingTransitionsList() {
        return ListUtil.fromCollection(this._outgoingTransitions.values());
    }

    public Set<Timer> getTimers() {
        if (this._timers == null) {
            return Collections.emptySet();
        }
        return this._timers;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    @Override
    public void setActions(Set<Action> actions) {
        this._actions = actions;
    }

    public void setLabelMap(Map<Locale, String> labelMap) {
        this._labelMap = labelMap;
    }

    public void setMetadata(String metadata) {
        this._metadata = metadata;
    }

    @Override
    public void setNotifications(Set<Notification> notifications) {
        this._notifications = notifications;
    }

    public void setTimers(Set<Timer> timers) {
        this._timers = timers;
    }
}

