/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.parser.NodeValidatorRegistry;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowValidator;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowValidator.class})
public class DefaultWorkflowValidator
implements WorkflowValidator {
    @Reference
    private NodeValidatorRegistry _nodeValidatorRegistry;

    public void validate(Definition definition) throws WorkflowException {
        State initialState = definition.getInitialState();
        if (initialState == null) {
            throw new KaleoDefinitionValidationException.MustSetInitialStateNode();
        }
        List terminalStates = definition.getTerminalStates();
        if (terminalStates.isEmpty()) {
            throw new KaleoDefinitionValidationException.MustSetTerminalStateNode();
        }
        if (definition.getForksCount() != definition.getJoinsCount()) {
            throw new KaleoDefinitionValidationException.UnbalancedForkAndJoinNodes();
        }
        Collection nodes = definition.getNodes();
        for (Node node : nodes) {
            NodeValidator<Node> nodeValidator = this._nodeValidatorRegistry.getNodeValidator(node.getNodeType());
            nodeValidator.validate(definition, node);
        }
    }
}

