/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.change.tracking.spi.display;

import com.liferay.change.tracking.spi.display.BaseCTDisplayRenderer;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.display.context.DisplayContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CTDisplayRenderer.class})
public class KaleoDefinitionVersionCTDisplayRenderer
extends BaseCTDisplayRenderer<KaleoDefinitionVersion> {
    private static final Log _log = LogFactoryUtil.getLog(KaleoDefinitionVersionCTDisplayRenderer.class);
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;

    public KaleoDefinitionVersion fetchLatestVersionedModel(KaleoDefinitionVersion kaleoDefinitionVersion) {
        try {
            return this._kaleoDefinitionVersionLocalService.fetchLatestKaleoDefinitionVersion(kaleoDefinitionVersion.getCompanyId(), kaleoDefinitionVersion.getName());
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    public Class<KaleoDefinitionVersion> getModelClass() {
        return KaleoDefinitionVersion.class;
    }

    public String getTitle(Locale locale, KaleoDefinitionVersion kaleoDefinitionVersion) {
        return kaleoDefinitionVersion.getTitle(locale);
    }

    public String getVersionName(KaleoDefinitionVersion kaleoDefinitionVersion) {
        return kaleoDefinitionVersion.getVersion();
    }

    public String renderPreview(DisplayContext<KaleoDefinitionVersion> displayContext) {
        KaleoDefinitionVersion kaleoDefinitionVersion = (KaleoDefinitionVersion)displayContext.getModel();
        return StringBundler.concat((String[])new String[]{"<pre>", HtmlUtil.escapeAttribute((String)kaleoDefinitionVersion.getContent()), "</pre>"});
    }

    public boolean showPreviewDiff() {
        return true;
    }

    protected void buildDisplay(BaseCTDisplayRenderer.DisplayBuilder<KaleoDefinitionVersion> displayBuilder) {
        KaleoDefinitionVersion kaleoDefinitionVersion = (KaleoDefinitionVersion)displayBuilder.getModel();
        displayBuilder.display("name", (Object)kaleoDefinitionVersion.getName()).display("title", (Object)kaleoDefinitionVersion.getTitle(displayBuilder.getLocale())).display("description", (Object)kaleoDefinitionVersion.getDescription()).display("created-by", () -> {
            String userName = kaleoDefinitionVersion.getUserName();
            if (Validator.isNotNull((String)userName)) {
                return userName;
            }
            return null;
        }).display("create-date", (Object)kaleoDefinitionVersion.getCreateDate()).display("last-modified", (Object)kaleoDefinitionVersion.getModifiedDate()).display("version", (Object)kaleoDefinitionVersion.getVersion());
    }
}

