/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.AddressRecipient;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.AssignmentType;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.RecipientType;
import com.liferay.portal.workflow.kaleo.definition.ResourceActionAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleRecipient;
import com.liferay.portal.workflow.kaleo.definition.ScriptAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.ScriptRecipient;
import com.liferay.portal.workflow.kaleo.definition.TemplateLanguage;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.UserAssignment;
import com.liferay.portal.workflow.kaleo.definition.UserRecipient;
import com.liferay.portal.workflow.kaleo.definition.export.NodeExporter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseNodeExporter
implements NodeExporter {
    public void exportNode(Node node, Element element, String namespace) {
        Element nodeElement = this.createNodeElement(element, namespace);
        this.addTextElement(nodeElement, "name", node.getName());
        if (Validator.isNotNull((String)node.getDescription())) {
            this.addTextElement(nodeElement, "description", node.getDescription());
        }
        if (Validator.isNotNull((String)node.getMetadata())) {
            this.addCDataElement(nodeElement, "metadata", node.getMetadata());
        }
        Set actions = node.getActions();
        Set notifications = node.getNotifications();
        if (!actions.isEmpty() || !notifications.isEmpty()) {
            Element actionsElement = nodeElement.addElement("actions");
            this._exportActionsElement(actions, notifications, actionsElement, "action", "notification");
        }
        this.exportAdditionalNodeElements(node, nodeElement);
        this._exportLabelsElement(nodeElement, node.getLabelMap());
        this._exportTransitionsElement(node, nodeElement);
    }

    protected void addCDataElement(Element element, String elementName, String text) {
        Element childElement = element.addElement(elementName);
        childElement.addCDATA(text);
    }

    protected void addTextElement(Element element, String elementName, String text) {
        Element childElement = element.addElement(elementName);
        if (Validator.isNotNull((String)text)) {
            childElement.addText(text);
        }
    }

    protected abstract Element createNodeElement(Element var1, String var2);

    protected abstract void exportAdditionalNodeElements(Node var1, Element var2);

    protected void exportAssignmentsElement(Set<Assignment> assignments, Element parentElement, String assignmentsElementName) {
        if (assignments.isEmpty()) {
            return;
        }
        Element assignmentsElement = parentElement.addElement(assignmentsElementName);
        Element resourceActionsElement = null;
        Element rolesElement = null;
        for (Assignment assignment : assignments) {
            AssignmentType assignmentType = assignment.getAssignmentType();
            if (assignmentType.equals((Object)AssignmentType.RESOURCE_ACTION)) {
                if (resourceActionsElement == null) {
                    resourceActionsElement = assignmentsElement.addElement("resource-actions");
                }
                ResourceActionAssignment resourceActionAssignment = (ResourceActionAssignment)assignment;
                this.addTextElement(resourceActionsElement, "resource-action", resourceActionAssignment.getActionId());
                continue;
            }
            if (assignmentType.equals((Object)AssignmentType.ROLE)) {
                if (rolesElement == null) {
                    rolesElement = assignmentsElement.addElement("roles");
                }
                Element roleElement = rolesElement.addElement("role");
                RoleAssignment roleAssignment = (RoleAssignment)assignment;
                this._populateRoleElement(roleElement, roleAssignment.getRoleId(), roleAssignment.getRoleType(), roleAssignment.getRoleName(), roleAssignment.isAutoCreate());
                continue;
            }
            if (assignmentType.equals((Object)AssignmentType.SCRIPT)) {
                Element scriptedAssignmentElement = assignmentsElement.addElement("scripted-assignment");
                ScriptAssignment scriptAssignment = (ScriptAssignment)assignment;
                ScriptLanguage scriptLanguage = scriptAssignment.getScriptLanguage();
                this.populateScriptingElement(scriptedAssignmentElement, scriptAssignment.getScript(), scriptLanguage.getValue(), scriptAssignment.getScriptRequiredContexts());
                continue;
            }
            if (!assignmentType.equals((Object)AssignmentType.USER)) continue;
            Element userElement = assignmentsElement.addElement("user");
            UserAssignment userAssignment = (UserAssignment)assignment;
            this._populateUserElement(userElement, userAssignment.getUserId(), userAssignment.getEmailAddress(), userAssignment.getScreenName());
        }
    }

    protected void exportTimersElement(Node node, Element nodeElement, String timersElementName, String timerElementName) {
        Set timers = node.getTimers();
        if (timers.isEmpty()) {
            return;
        }
        Element timersElement = nodeElement.addElement(timersElementName);
        for (Timer timer : timers) {
            Element timerElement = timersElement.addElement(timerElementName);
            this.addTextElement(timerElement, "name", timer.getName());
            if (Validator.isNotNull((String)timer.getDescription())) {
                this.addTextElement(timerElement, "description", timer.getDescription());
            }
            this._addDelayDuration(timerElement, "delay", timer.getDelayDuration());
            DelayDuration recurrenceDelayDuration = timer.getRecurrence();
            if (recurrenceDelayDuration != null) {
                this._addDelayDuration(timerElement, "recurrence", recurrenceDelayDuration);
            }
            if (timer.isBlocking()) {
                this.addTextElement(timerElement, "blocking", String.valueOf(timer.isBlocking()));
            }
            Set actions = timer.getActions();
            Set notifications = timer.getNotifications();
            Set assignments = timer.getReassignments();
            if (actions.isEmpty() && notifications.isEmpty() && assignments.isEmpty()) continue;
            Element timerActionsElement = timerElement.addElement("timer-actions");
            this._exportActionsElement(actions, notifications, timerActionsElement, "timer-action", "timer-notification");
            this.exportAssignmentsElement(assignments, timerActionsElement, "reassignments");
        }
    }

    protected void populateScriptingElement(Element scriptingElement, String script, String scriptLanguage, String scriptRequiredContexts) {
        this.addCDataElement(scriptingElement, "script", script);
        this.addTextElement(scriptingElement, "script-language", scriptLanguage);
        if (Validator.isNotNull((String)scriptRequiredContexts)) {
            this.addTextElement(scriptingElement, "script-required-contexts", scriptRequiredContexts);
        }
    }

    private void _addDelayDuration(Element timerElement, String elementName, DelayDuration delayDuration) {
        Element delayElement = timerElement.addElement(elementName);
        this.addTextElement(delayElement, "duration", String.valueOf(delayDuration.getDuration()));
        DurationScale durationScale = delayDuration.getDurationScale();
        this.addTextElement(delayElement, "scale", durationScale.getValue());
    }

    private void _exportActionElement(Element actionElement, Action action) {
        this.addTextElement(actionElement, "name", action.getName());
        if (Validator.isNotNull((String)action.getDescription())) {
            this.addTextElement(actionElement, "description", action.getDescription());
        }
        ScriptLanguage scriptLanguage = action.getScriptLanguage();
        this.populateScriptingElement(actionElement, action.getScript(), scriptLanguage.getValue(), action.getScriptRequiredContexts());
        if (action.getPriority() > 0) {
            this.addTextElement(actionElement, "priority", String.valueOf(action.getPriority()));
        }
        ExecutionType executionType = action.getExecutionType();
        this.addTextElement(actionElement, "execution-type", executionType.getValue());
    }

    private void _exportActionsElement(Set<Action> actions, Set<Notification> notifications, Element actionsElement, String actionElementName, String notificationElementName) {
        for (Action action : actions) {
            Element actionElement = actionsElement.addElement(actionElementName);
            this._exportActionElement(actionElement, action);
        }
        for (Notification notification : notifications) {
            Element notificationElement = actionsElement.addElement(notificationElementName);
            this._exportNotificationElement(notificationElement, notification);
        }
    }

    private void _exportLabelsElement(Element element, Map<Locale, String> labelMap) {
        if (MapUtil.isEmpty(labelMap)) {
            return;
        }
        Element labelsElement = element.addElement("labels");
        for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
            Element labelElement = labelsElement.addElement("label");
            labelElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)entry.getKey()));
            labelElement.addText(entry.getValue());
        }
    }

    private void _exportNotificationElement(Element notificationElement, Notification notification) {
        this.addTextElement(notificationElement, "name", notification.getName());
        if (Validator.isNotNull((String)notification.getDescription())) {
            this.addTextElement(notificationElement, "description", notification.getDescription());
        }
        this.addCDataElement(notificationElement, "template", notification.getTemplate());
        TemplateLanguage templateLanguage = notification.getTemplateLanguage();
        this.addTextElement(notificationElement, "template-language", templateLanguage.getValue());
        Set notificationTypes = notification.getNotificationTypes();
        for (Object notificationType : notificationTypes) {
            this.addTextElement(notificationElement, "notification-type", notificationType.getValue());
        }
        Map recipientsMap = notification.getRecipientsMap();
        for (Map.Entry entry : recipientsMap.entrySet()) {
            Set recipients = (Set)entry.getValue();
            NotificationReceptionType notificationReceptionType = (NotificationReceptionType)entry.getKey();
            this._exportRecipientsElement(notificationElement, recipients, notificationReceptionType);
        }
        ExecutionType executionType = notification.getExecutionType();
        this.addTextElement(notificationElement, "execution-type", executionType.getValue());
    }

    private void _exportRecipientsElement(Element notificationElement, Set<Recipient> recipients, NotificationReceptionType notificationReceptionType) {
        if (recipients.isEmpty()) {
            return;
        }
        Element recipientsElement = notificationElement.addElement("recipients");
        recipientsElement.addAttribute("receptionType", notificationReceptionType.getValue());
        Element rolesElement = null;
        for (Recipient recipient : recipients) {
            RecipientType recipientType = recipient.getRecipientType();
            if (recipientType.equals((Object)RecipientType.ADDRESS)) {
                AddressRecipient addressRecipient = (AddressRecipient)recipient;
                this.addTextElement(recipientsElement, "address", addressRecipient.getAddress());
                continue;
            }
            if (recipientType.equals((Object)RecipientType.ASSIGNEES)) {
                this.addTextElement(recipientsElement, "assignees", null);
                continue;
            }
            if (recipientType.equals((Object)RecipientType.ROLE)) {
                if (rolesElement == null) {
                    rolesElement = recipientsElement.addElement("roles");
                }
                Element roleElement = rolesElement.addElement("role");
                RoleRecipient roleRecipient = (RoleRecipient)recipient;
                this._populateRoleElement(roleElement, roleRecipient.getRoleId(), roleRecipient.getRoleType(), roleRecipient.getRoleName(), roleRecipient.isAutoCreate());
                continue;
            }
            if (recipientType.equals((Object)RecipientType.SCRIPT)) {
                Element scriptedRecipientElement = recipientsElement.addElement("scripted-recipient");
                ScriptRecipient scriptRecipient = (ScriptRecipient)recipient;
                ScriptLanguage scriptLanguage = scriptRecipient.getScriptLanguage();
                this.populateScriptingElement(scriptedRecipientElement, scriptRecipient.getScript(), scriptLanguage.getValue(), scriptRecipient.getScriptRequiredContexts());
                continue;
            }
            if (!recipientType.equals((Object)RecipientType.USER)) continue;
            Element userElement = recipientsElement.addElement("user");
            UserRecipient userRecipient = (UserRecipient)recipient;
            this._populateUserElement(userElement, userRecipient.getUserId(), userRecipient.getEmailAddress(), userRecipient.getScreenName());
        }
    }

    private void _exportTransitionsElement(Node node, Element nodeElement) {
        List outgoingTransitions = node.getOutgoingTransitionsList();
        if (outgoingTransitions.isEmpty()) {
            return;
        }
        Element transitionsElement = nodeElement.addElement("transitions");
        for (Transition outgoingTransition : outgoingTransitions) {
            Element transition = transitionsElement.addElement("transition");
            this.addTextElement(transition, "default", String.valueOf(outgoingTransition.isDefault()));
            this.addTextElement(transition, "name", outgoingTransition.getName());
            Node targetNode = outgoingTransition.getTargetNode();
            this.addTextElement(transition, "target", targetNode.getName());
            this._exportLabelsElement(transition, outgoingTransition.getLabelMap());
        }
    }

    private void _populateRoleElement(Element roleElement, long roleId, String roleType, String roleName, boolean autoCreate) {
        if (roleId > 0L) {
            this.addTextElement(roleElement, "role-id", String.valueOf(roleId));
        } else {
            this.addTextElement(roleElement, "role-type", roleType);
            this.addTextElement(roleElement, "name", roleName);
            if (!autoCreate) {
                this.addTextElement(roleElement, "auto-create", String.valueOf(autoCreate));
            }
        }
    }

    private void _populateUserElement(Element userElement, long userId, String emailAddress, String screenName) {
        if (userId > 0L) {
            this.addTextElement(userElement, "user-id", String.valueOf(userId));
        }
        if (Validator.isNotNull((String)emailAddress)) {
            this.addTextElement(userElement, "email-address", emailAddress);
        }
        if (Validator.isNotNull((String)screenName)) {
            this.addTextElement(userElement, "screen-name", screenName);
        }
    }
}

