/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.definition.export.NodeExporter;
import com.liferay.portal.workflow.kaleo.definition.internal.export.BaseNodeExporter;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"node.type=TASK"}, service={NodeExporter.class})
public class TaskNodeExporter
extends BaseNodeExporter
implements NodeExporter {
    @Override
    protected Element createNodeElement(Element element, String namespace) {
        return element.addElement("task", namespace);
    }

    @Override
    protected void exportAdditionalNodeElements(Node node, Element nodeElement) {
        Task task = (Task)node;
        this.exportAssignmentsElement(task.getAssignments(), nodeElement, "assignments");
        this._exportTaskForms(task.getTaskForms(), nodeElement, "task-forms");
        this.exportTimersElement((Node)task, nodeElement, "task-timers", "task-timer");
    }

    private void _exportTaskForms(Set<TaskForm> taskForms, Element parentElement, String taskFormsElementName) {
        if (SetUtil.isEmpty(taskForms)) {
            return;
        }
        Element taskFormsElement = parentElement.addElement(taskFormsElementName);
        for (TaskForm taskForm : taskForms) {
            Element taskFormElement = taskFormsElement.addElement("task-form");
            this.addTextElement(taskFormElement, "name", taskForm.getName());
            this.addTextElement(taskFormElement, "description", taskForm.getDescription());
            if (Validator.isNotNull((String)taskForm.getFormDefinition())) {
                this.addTextElement(taskFormElement, "form-definition", taskForm.getFormDefinition());
            } else if (taskForm.getTaskFormReference() != null) {
                TaskFormReference taskFormReference = taskForm.getTaskFormReference();
                Element formReferenceElement = taskFormElement.addElement("form-reference");
                this.addTextElement(formReferenceElement, "company-id", String.valueOf(taskFormReference.getCompanyId()));
                this.addTextElement(formReferenceElement, "form-id", String.valueOf(taskFormReference.getFormId()));
                this.addTextElement(formReferenceElement, "form-uuid", taskFormReference.getFormUuid());
                this.addTextElement(formReferenceElement, "group-id", String.valueOf(taskFormReference.getGroupId()));
            }
            this.addCDataElement(taskFormElement, "metadata", taskForm.getMetadata());
            this.addTextElement(taskFormElement, "priority", String.valueOf(taskForm.getPriority()));
        }
    }
}

