/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export.builder;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.BaseNodeBuilder;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.NodeBuilder;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskFormLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"node.type=TASK"}, service={NodeBuilder.class})
public class TaskNodeBuilder
extends BaseNodeBuilder<Task>
implements NodeBuilder {
    @Reference
    private KaleoTaskFormLocalService _kaleoTaskFormLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;

    @Override
    protected Task createNode(KaleoNode kaleoNode) throws PortalException {
        KaleoTask kaleoTask = this._kaleoTaskLocalService.getKaleoNodeKaleoTask(kaleoNode.getKaleoNodeId());
        Task task = new Task(kaleoNode.getName(), kaleoNode.getDescription());
        task.setAssignments(this.buildAssigments(KaleoTask.class.getName(), kaleoTask.getKaleoTaskId()));
        Set<TaskForm> taskForms = this._buildTaskForms(kaleoTask.getKaleoTaskId());
        task.addTaskForms(taskForms);
        return task;
    }

    private Set<TaskForm> _buildTaskForms(long kaleoTaskId) throws PortalException {
        List kaleoTaskForms = this._kaleoTaskFormLocalService.getKaleoTaskForms(kaleoTaskId);
        TreeSet<TaskForm> taskForms = new TreeSet<TaskForm>();
        for (KaleoTaskForm kaleoTaskForm : kaleoTaskForms) {
            TaskForm taskForm = new TaskForm(kaleoTaskForm.getName(), kaleoTaskForm.getPriority());
            taskForm.setDescription(kaleoTaskForm.getDescription());
            taskForm.setMetadata(kaleoTaskForm.getMetadata());
            if (Validator.isNotNull((String)kaleoTaskForm.getFormDefinition())) {
                taskForm.setFormDefinition(kaleoTaskForm.getFormDefinition());
            } else {
                TaskFormReference taskFormReference = new TaskFormReference();
                taskFormReference.setCompanyId(kaleoTaskForm.getFormCompanyId());
                taskFormReference.setFormUuid(kaleoTaskForm.getFormUuid());
                taskFormReference.setFormId(kaleoTaskForm.getFormId());
                taskFormReference.setGroupId(kaleoTaskForm.getFormGroupId());
                taskForm.setTaskFormReference(taskFormReference);
            }
            taskForms.add(taskForm);
        }
        return taskForms;
    }
}

