/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowValidator;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={WorkflowValidator.class})
public class DefaultWorkflowValidator
implements WorkflowValidator {
    private ServiceTrackerMap<NodeType, NodeValidator<Node>> _serviceTrackerMap;

    public void validate(Definition definition) throws WorkflowException {
        State initialState = definition.getInitialState();
        if (initialState == null) {
            throw new KaleoDefinitionValidationException.MustSetInitialStateNode();
        }
        List terminalStates = definition.getTerminalStates();
        if (terminalStates.isEmpty()) {
            throw new KaleoDefinitionValidationException.MustSetTerminalStateNode();
        }
        if (definition.getForksCount() != definition.getJoinsCount()) {
            throw new KaleoDefinitionValidationException.UnbalancedForkAndJoinNodes();
        }
        Collection nodes = definition.getNodes();
        for (Node node : nodes) {
            NodeValidator nodeValidator = (NodeValidator)this._serviceTrackerMap.getService((Object)node.getNodeType());
            nodeValidator.validate(definition, node);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, NodeValidator.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.create((BundleContext)bundleContext, (nodeValidator, emitter) -> emitter.emit((Object)nodeValidator.getNodeType())));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

