/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.workflow.kaleo.definition.ActionAware;
import com.liferay.portal.workflow.kaleo.definition.AddressRecipient;
import com.liferay.portal.workflow.kaleo.definition.AssigneesRecipient;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.Condition;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.Fork;
import com.liferay.portal.workflow.kaleo.definition.Join;
import com.liferay.portal.workflow.kaleo.definition.JoinXor;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationAware;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.ResourceActionAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleRecipient;
import com.liferay.portal.workflow.kaleo.definition.ScriptAction;
import com.liferay.portal.workflow.kaleo.definition.ScriptAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptRecipient;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.UpdateStatusAction;
import com.liferay.portal.workflow.kaleo.definition.UserAssignment;
import com.liferay.portal.workflow.kaleo.definition.UserRecipient;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import com.liferay.portal.workflow.kaleo.definition.util.WorkflowDefinitionContentUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={WorkflowModelParser.class})
public class XMLWorkflowModelParser
implements WorkflowModelParser {
    private boolean _validate;

    public Definition parse(InputStream inputStream) throws WorkflowException {
        try {
            return this.parse(StringUtil.read((InputStream)inputStream));
        }
        catch (Exception exception) {
            throw new WorkflowDefinitionFileException("Unable to parse definition", (Throwable)exception);
        }
    }

    public Definition parse(String content) throws WorkflowException {
        try {
            Document document = SAXReaderUtil.read((String)this._toXML(content), (boolean)this._validate);
            return this._parse(document);
        }
        catch (Exception exception) {
            throw new WorkflowDefinitionFileException("Unable to parse definition", (Throwable)exception);
        }
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._validate = GetterUtil.getBoolean((Object)properties.get("validating"), (boolean)true);
    }

    private Definition _parse(Document document) throws Exception {
        Element rootElement = document.getRootElement();
        String name = rootElement.elementTextTrim("name");
        String description = StringUtil.trim((String)rootElement.elementText("description"));
        int version = GetterUtil.getInteger((String)rootElement.elementTextTrim("version"));
        Definition definition = new Definition(name, description, document.formattedString(), version);
        List conditionElements = rootElement.elements("condition");
        for (Object conditionElement : conditionElements) {
            Condition condition = this._parseCondition((Element)conditionElement);
            definition.addNode((Node)condition);
        }
        List forkElements = rootElement.elements("fork");
        for (Object forkElement : forkElements) {
            Fork fork = this._parseFork((Element)forkElement);
            definition.addNode((Node)fork);
        }
        List joinElements = rootElement.elements("join");
        for (Object joinElement : joinElements) {
            Join join = this._parseJoin((Element)joinElement);
            definition.addNode((Node)join);
        }
        List joinXorElements = rootElement.elements("join-xor");
        for (Object joinXorElement : joinXorElements) {
            JoinXor joinXor = this._parseJoinXor((Element)joinXorElement);
            definition.addNode((Node)joinXor);
        }
        List stateElements = rootElement.elements("state");
        for (Element stateElement : stateElements) {
            State state = this._parseState(stateElement);
            definition.addNode((Node)state);
        }
        List taskElements = rootElement.elements("task");
        for (Element taskElement : taskElements) {
            Task task = this._parseTask(taskElement);
            definition.addNode((Node)task);
        }
        this._parseTransitions(definition, conditionElements, forkElements, joinElements, joinXorElements, stateElements, taskElements);
        return definition;
    }

    private void _parseActionElements(List<Element> actionElements, ActionAware actionAware) throws Exception {
        if (actionElements.isEmpty()) {
            return;
        }
        HashSet<Object> actions = new HashSet<Object>();
        for (Element actionElement : actionElements) {
            String name = actionElement.elementTextTrim("name");
            String description = StringUtil.trim((String)actionElement.elementText("description"));
            String executionType = actionElement.elementTextTrim("execution-type");
            int priority = GetterUtil.getInteger((String)actionElement.elementTextTrim("priority"));
            if (actionElement.element("script") != null) {
                String script = StringUtil.trim((String)actionElement.elementText("script"));
                String scriptLanguage = actionElement.elementTextTrim("script-language");
                String scriptRequiredContexts = actionElement.elementTextTrim("script-required-contexts");
                actions.add(new ScriptAction(name, description, executionType, script, scriptLanguage, scriptRequiredContexts, priority));
                continue;
            }
            if (actionElement.element("status") == null) continue;
            actions.add(new UpdateStatusAction(name, description, executionType, GetterUtil.getInteger((String)actionElement.elementText("status")), priority));
        }
        actionAware.setActions(actions);
    }

    private void _parseActionsElement(Element actionsElement, Node node) throws Exception {
        if (actionsElement == null) {
            return;
        }
        List actionElements = actionsElement.elements("action");
        this._parseActionElements(actionElements, (ActionAware)node);
        List notificationElements = actionsElement.elements("notification");
        this._parseNotificationElements(notificationElements, (NotificationAware)node);
    }

    private Set<Assignment> _parseAssignments(Element assignmentsElement) throws Exception {
        Element rolesElement;
        if (assignmentsElement == null) {
            return Collections.emptySet();
        }
        HashSet<Assignment> assignments = new HashSet<Assignment>();
        Element resourceActionsElement = assignmentsElement.element("resource-actions");
        if (resourceActionsElement != null) {
            List resourceActionElements = resourceActionsElement.elements("resource-action");
            for (Element resourceActionElement : resourceActionElements) {
                String actionId = resourceActionElement.getTextTrim();
                if (!Validator.isNotNull((String)actionId)) continue;
                ResourceActionAssignment resourceActionAssignment = new ResourceActionAssignment(actionId);
                assignments.add((Assignment)resourceActionAssignment);
            }
        }
        if ((rolesElement = assignmentsElement.element("roles")) != null) {
            List roleAssignmentElements = rolesElement.elements("role");
            for (Element roleAssignmentElement : roleAssignmentElements) {
                long roleId = GetterUtil.getLong((String)roleAssignmentElement.elementTextTrim("role-id"));
                String roleType = GetterUtil.getString((String)roleAssignmentElement.elementTextTrim("role-type"), (String)"regular");
                String name = roleAssignmentElement.elementTextTrim("name");
                RoleAssignment roleAssignment = null;
                if (Validator.isNotNull((String)name)) {
                    roleAssignment = new RoleAssignment(name, roleType);
                    roleAssignment.setAutoCreate(GetterUtil.getBoolean((String)roleAssignmentElement.elementTextTrim("auto-create"), (boolean)true));
                } else {
                    roleAssignment = new RoleAssignment(roleId);
                }
                assignments.add((Assignment)roleAssignment);
            }
        }
        List scriptedAssignmentElements = assignmentsElement.elements("scripted-assignment");
        for (Element scriptedAssignmentElement : scriptedAssignmentElements) {
            String script = StringUtil.trim((String)scriptedAssignmentElement.elementText("script"));
            String scriptLanguage = scriptedAssignmentElement.elementTextTrim("script-language");
            String scriptRequiredContexts = scriptedAssignmentElement.elementTextTrim("script-required-contexts");
            ScriptAssignment scriptAssignment = new ScriptAssignment(script, scriptLanguage, scriptRequiredContexts);
            assignments.add((Assignment)scriptAssignment);
        }
        List userAssignmentElements = assignmentsElement.elements("user");
        for (Element userAssignmentElement : userAssignmentElements) {
            long userId = GetterUtil.getLong((String)userAssignmentElement.elementTextTrim("user-id"));
            String screenName = userAssignmentElement.elementTextTrim("screen-name");
            String emailAddress = userAssignmentElement.elementTextTrim("email-address");
            UserAssignment userAssignment = new UserAssignment(userId, screenName, emailAddress);
            assignments.add((Assignment)userAssignment);
        }
        return assignments;
    }

    private Condition _parseCondition(Element conditionElement) throws Exception {
        String name = conditionElement.elementTextTrim("name");
        String description = StringUtil.trim((String)conditionElement.elementText("description"));
        String script = conditionElement.elementText("script");
        String scriptLanguage = conditionElement.elementTextTrim("script-language");
        String scriptRequiredContexts = conditionElement.elementTextTrim("script-required-contexts");
        Condition condition = new Condition(name, description, script, scriptLanguage, scriptRequiredContexts);
        condition.setMetadata(conditionElement.elementTextTrim("metadata"));
        Element actionsElement = conditionElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)condition);
        condition.setLabelMap(this._parseLabels(conditionElement.element("labels")));
        Element timersElement = conditionElement.element("timers");
        this._parseTimerElements(timersElement, (Node)condition);
        return condition;
    }

    private DelayDuration _parseDelay(Element delayElement) throws Exception {
        if (delayElement == null) {
            return null;
        }
        double duration = GetterUtil.getDouble((String)delayElement.elementTextTrim("duration"));
        DurationScale durationScale = DurationScale.parse((String)delayElement.elementTextTrim("scale"));
        return new DelayDuration(duration, durationScale);
    }

    private Fork _parseFork(Element forkElement) throws Exception {
        String name = forkElement.elementTextTrim("name");
        String description = StringUtil.trim((String)forkElement.elementText("description"));
        Fork fork = new Fork(name, description);
        fork.setMetadata(forkElement.elementTextTrim("metadata"));
        Element actionsElement = forkElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)fork);
        fork.setLabelMap(this._parseLabels(forkElement.element("labels")));
        Element timersElement = forkElement.element("timers");
        this._parseTimerElements(timersElement, (Node)fork);
        return fork;
    }

    private Join _parseJoin(Element joinElement) throws Exception {
        String name = joinElement.elementTextTrim("name");
        String description = StringUtil.trim((String)joinElement.elementText("description"));
        Join join = new Join(name, description);
        join.setMetadata(joinElement.elementTextTrim("metadata"));
        Element actionsElement = joinElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)join);
        join.setLabelMap(this._parseLabels(joinElement.element("labels")));
        Element timersElement = joinElement.element("timers");
        this._parseTimerElements(timersElement, (Node)join);
        return join;
    }

    private JoinXor _parseJoinXor(Element joinXorElement) throws Exception {
        String name = joinXorElement.elementTextTrim("name");
        String description = StringUtil.trim((String)joinXorElement.elementText("description"));
        JoinXor joinXor = new JoinXor(name, description);
        joinXor.setMetadata(joinXorElement.elementTextTrim("metadata"));
        Element actionsElement = joinXorElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)joinXor);
        joinXor.setLabelMap(this._parseLabels(joinXorElement.element("labels")));
        Element timersElement = joinXorElement.element("timers");
        this._parseTimerElements(timersElement, (Node)joinXor);
        return joinXor;
    }

    private Map<Locale, String> _parseLabels(Element labelsElement) {
        if (labelsElement == null) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> labelMap = new HashMap<Locale, String>();
        for (Element labelElement : labelsElement.elements()) {
            labelMap.put(LocaleUtil.fromLanguageId((String)labelElement.attributeValue("language-id")), labelElement.getText());
        }
        return labelMap;
    }

    private void _parseNotificationElements(List<Element> notificationElements, NotificationAware notificationAware) throws Exception {
        if (notificationElements.isEmpty()) {
            return;
        }
        HashSet<Notification> notifications = new HashSet<Notification>();
        for (Element notificationElement : notificationElements) {
            String name = notificationElement.elementTextTrim("name");
            String description = StringUtil.trim((String)notificationElement.elementText("description"));
            String executionType = notificationElement.elementTextTrim("execution-type");
            String template = StringUtil.trim((String)notificationElement.elementText("template"));
            String templateLanguage = notificationElement.elementTextTrim("template-language");
            Notification notification = new Notification(name, description, executionType, template, templateLanguage);
            List notificationTypeElements = notificationElement.elements("notification-type");
            for (Element notificationTypeElement : notificationTypeElements) {
                notification.addNotificationType(notificationTypeElement.getTextTrim());
            }
            List recipientsElements = notificationElement.elements("recipients");
            for (Element recipientsElement : recipientsElements) {
                this._parseRecipients(recipientsElement, notification, NotificationReceptionType.parse((String)recipientsElement.attributeValue("receptionType")));
            }
            notifications.add(notification);
        }
        notificationAware.setNotifications(notifications);
    }

    private void _parseRecipients(Element recipientsElement, Notification notification, NotificationReceptionType notificationReceptionType) throws Exception {
        Element rolesElement;
        if (recipientsElement == null) {
            return;
        }
        List addressRecipientElements = recipientsElement.elements("address");
        for (Element addressRecipientElement : addressRecipientElements) {
            AddressRecipient addressRecipient = new AddressRecipient(addressRecipientElement.getTextTrim());
            addressRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)addressRecipient);
        }
        Element assigneesRecipientElement = recipientsElement.element("assignees");
        if (assigneesRecipientElement != null) {
            AssigneesRecipient assigneesRecipient = new AssigneesRecipient();
            assigneesRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)assigneesRecipient);
        }
        if ((rolesElement = recipientsElement.element("roles")) != null) {
            List roleReceipientElements = rolesElement.elements("role");
            for (Element roleReceipientElement : roleReceipientElements) {
                long roleId = GetterUtil.getLong((String)roleReceipientElement.elementTextTrim("role-id"));
                String roleType = GetterUtil.getString((String)roleReceipientElement.elementTextTrim("role-type"), (String)"regular");
                RoleRecipient roleRecipient = null;
                if (roleId > 0L) {
                    roleRecipient = new RoleRecipient(roleId, roleType);
                } else {
                    String name = roleReceipientElement.elementTextTrim("name");
                    roleRecipient = new RoleRecipient(name, roleType);
                    roleRecipient.setAutoCreate(GetterUtil.getBoolean((String)roleReceipientElement.elementTextTrim("auto-create"), (boolean)true));
                }
                roleRecipient.setNotificationReceptionType(notificationReceptionType);
                notification.addRecipients((Recipient)roleRecipient);
            }
        }
        List scriptedRecipientElements = recipientsElement.elements("scripted-recipient");
        for (Element scriptedRecipientElement : scriptedRecipientElements) {
            String script = scriptedRecipientElement.elementText("script");
            String scriptLanguage = scriptedRecipientElement.elementTextTrim("script-language");
            String scriptRequiredContexts = scriptedRecipientElement.elementTextTrim("script-required-contexts");
            ScriptRecipient scriptRecipient = new ScriptRecipient(script, scriptLanguage, scriptRequiredContexts);
            scriptRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)scriptRecipient);
        }
        List userRecipientElements = recipientsElement.elements("user");
        for (Element userRecipientElement : userRecipientElements) {
            long userId = GetterUtil.getLong((String)userRecipientElement.elementTextTrim("user-id"));
            String screenName = userRecipientElement.elementTextTrim("screen-name");
            String emailAddress = userRecipientElement.elementTextTrim("email-address");
            UserRecipient userRecipient = new UserRecipient(userId, screenName, emailAddress);
            userRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)userRecipient);
        }
    }

    private State _parseState(Element stateElement) throws Exception {
        String name = stateElement.elementTextTrim("name");
        String description = StringUtil.trim((String)stateElement.elementText("description"));
        boolean initial = GetterUtil.getBoolean((String)stateElement.elementTextTrim("initial"));
        State state = new State(name, description, initial);
        state.setMetadata(stateElement.elementTextTrim("metadata"));
        Element actionsElement = stateElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)state);
        state.setLabelMap(this._parseLabels(stateElement.element("labels")));
        Element timersElement = stateElement.element("timers");
        this._parseTimerElements(timersElement, (Node)state);
        return state;
    }

    private Task _parseTask(Element taskElement) throws Exception {
        String name = taskElement.elementTextTrim("name");
        String description = StringUtil.trim((String)taskElement.elementText("description"));
        Task task = new Task(name, description);
        task.setMetadata(taskElement.elementTextTrim("metadata"));
        Element actionsElement = taskElement.element("actions");
        this._parseActionsElement(actionsElement, (Node)task);
        Element assignmentsElement = taskElement.element("assignments");
        if (assignmentsElement != null) {
            task.setAssignments(this._parseAssignments(assignmentsElement));
        }
        task.setLabelMap(this._parseLabels(taskElement.element("labels")));
        Element formsElement = taskElement.element("task-forms");
        this._parseTaskFormsElements(formsElement, task);
        Element timersElement = taskElement.element("task-timers");
        this._parseTaskTimerElements(timersElement, (Node)task);
        return task;
    }

    private void _parseTaskFormsElements(Element taskFormsElement, Task task) {
        if (taskFormsElement == null) {
            return;
        }
        List taskFormElements = taskFormsElement.elements("task-form");
        if (ListUtil.isEmpty((List)taskFormElements)) {
            return;
        }
        for (Element taskFormElement : taskFormElements) {
            String formDefinition;
            String name = taskFormElement.elementTextTrim("name");
            int priority = GetterUtil.getInteger((String)taskFormElement.elementTextTrim("priority"));
            TaskForm taskForm = new TaskForm(name, priority);
            String description = StringUtil.trim((String)taskFormElement.elementText("description"));
            if (Validator.isNotNull((String)description)) {
                taskForm.setDescription(description);
            }
            if (Validator.isNotNull((String)(formDefinition = taskFormElement.elementTextTrim("form-definition")))) {
                taskForm.setFormDefinition(formDefinition);
            } else {
                Element formReferenceElement = taskFormElement.element("form-reference");
                TaskFormReference taskFormReference = new TaskFormReference();
                taskFormReference.setCompanyId(GetterUtil.getLong((String)formReferenceElement.elementTextTrim("company-id")));
                taskFormReference.setGroupId(GetterUtil.getLong((String)formReferenceElement.elementTextTrim("group-id")));
                taskFormReference.setFormId(GetterUtil.getLong((String)formReferenceElement.elementTextTrim("form-id")));
                taskFormReference.setFormUuid(formReferenceElement.elementTextTrim("form-uuid"));
                taskForm.setTaskFormReference(taskFormReference);
            }
            String metadata = taskFormElement.elementTextTrim("metadata");
            if (Validator.isNotNull((String)metadata)) {
                taskForm.setMetadata(metadata);
            }
            task.addTaskForm(taskForm);
        }
    }

    private void _parseTaskTimerElements(Element taskTimersElement, Node node) throws Exception {
        if (taskTimersElement == null) {
            return;
        }
        List taskTimerElements = taskTimersElement.elements("task-timer");
        if (taskTimerElements.isEmpty()) {
            return;
        }
        HashSet<Timer> timers = new HashSet<Timer>();
        for (Element timerElement : taskTimerElements) {
            Timer timer = this._parseTimerElement(timerElement, true);
            timers.add(timer);
        }
        node.setTimers(timers);
    }

    private void _parseTimerActions(Element timersElement, Timer timer) throws Exception {
        if (timersElement == null) {
            return;
        }
        List timerActionElements = timersElement.elements("timer-action");
        this._parseActionElements(timerActionElements, (ActionAware)timer);
        List timerNotificationElements = timersElement.elements("timer-notification");
        this._parseNotificationElements(timerNotificationElements, (NotificationAware)timer);
        Element reassignmentsElement = timersElement.element("reassignments");
        if (reassignmentsElement != null) {
            Set<Assignment> assignments = this._parseAssignments(reassignmentsElement);
            timer.setReassignments(assignments);
        }
    }

    private Timer _parseTimerElement(Element timerElement, boolean taskTimer) throws Exception {
        String name = timerElement.elementTextTrim("name");
        String description = StringUtil.trim((String)timerElement.elementText("description"));
        boolean blocking = GetterUtil.getBoolean((String)timerElement.elementTextTrim("blocking"), (!taskTimer ? 1 : 0) != 0);
        Timer timer = new Timer(name, description, blocking);
        Element delayElement = timerElement.element("delay");
        timer.setDelayDuration(this._parseDelay(delayElement));
        if (!blocking) {
            Element recurrenceElement = timerElement.element("recurrence");
            timer.setRecurrence(this._parseDelay(recurrenceElement));
        }
        Element timerActions = timerElement.element("timer-actions");
        this._parseTimerActions(timerActions, timer);
        return timer;
    }

    private void _parseTimerElements(Element timersElement, Node node) throws Exception {
        if (timersElement == null) {
            return;
        }
        List timerElements = timersElement.elements("timer");
        if (timerElements.isEmpty()) {
            return;
        }
        HashSet<Timer> timers = new HashSet<Timer>();
        for (Element timerElement : timerElements) {
            Timer timer = this._parseTimerElement(timerElement, false);
            timers.add(timer);
        }
        node.setTimers(timers);
    }

    private void _parseTransition(Definition definition, Element nodeElement) throws Exception {
        String sourceName = nodeElement.elementTextTrim("name");
        Element transitionsElement = nodeElement.element("transitions");
        if (transitionsElement == null) {
            return;
        }
        Node sourceNode = definition.getNode(sourceName);
        List transitionElements = transitionsElement.elements("transition");
        for (Element transitionElement : transitionElements) {
            String transitionName = transitionElement.elementTextTrim("name");
            String targetName = transitionElement.elementTextTrim("target");
            Node targetNode = definition.getNode(targetName);
            boolean defaultValue = GetterUtil.getBoolean((String)transitionElement.elementTextTrim("default"), (boolean)true);
            Transition transition = new Transition(defaultValue, this._parseLabels(transitionElement.element("labels")), transitionName, sourceNode, targetNode);
            Element timerElement = transitionElement.element("timer");
            if (timerElement != null) {
                Timer timer = this._parseTimerElement(timerElement, false);
                transition.setTimers(timer);
            }
            sourceNode.addOutgoingTransition(transition);
            if (targetNode == null) continue;
            targetNode.addIncomingTransition(transition);
        }
    }

    private void _parseTransitions(Definition definition, List<Element> conditionElements, List<Element> forkElements, List<Element> joinElements, List<Element> joinXorElements, List<Element> stateElements, List<Element> taskElements) throws Exception {
        for (Element conditionElement : conditionElements) {
            this._parseTransition(definition, conditionElement);
        }
        for (Element forkElement : forkElements) {
            this._parseTransition(definition, forkElement);
        }
        for (Element joinElement : joinElements) {
            this._parseTransition(definition, joinElement);
        }
        for (Element joinXorElement : joinXorElements) {
            this._parseTransition(definition, joinXorElement);
        }
        for (Element stateElement : stateElements) {
            this._parseTransition(definition, stateElement);
        }
        for (Element taskElement : taskElements) {
            this._parseTransition(definition, taskElement);
        }
    }

    private String _toXML(String content) throws WorkflowException {
        if (Validator.isNotNull((String)content) && content.startsWith("{")) {
            return WorkflowDefinitionContentUtil.toXML((String)content);
        }
        return content;
    }
}

