/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.export.DefinitionExporter;
import com.liferay.portal.workflow.kaleo.definition.export.NodeExporter;
import com.liferay.portal.workflow.kaleo.definition.export.builder.DefinitionBuilder;
import com.liferay.portal.workflow.kaleo.definition.internal.export.NodeExporterRegistry;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefinitionExporter.class})
public class XMLDefinitionExporter
implements DefinitionExporter {
    @Reference
    private DefinitionBuilder _definitionBuilder;
    private String _namespace;
    @Reference
    private NodeExporterRegistry _nodeExporterRegistry;
    private String _schemaVersion;
    private String _version = ReleaseInfo.getVersion();

    public String export(Definition definition) throws PortalException {
        return this.doExport(definition);
    }

    public String export(long kaleoDefinitionId) throws PortalException {
        Definition definition = this._definitionBuilder.buildDefinition(kaleoDefinitionId);
        return this.doExport(definition);
    }

    public String export(long companyId, String name, int version) throws PortalException {
        Definition definition = this._definitionBuilder.buildDefinition(companyId, name, version);
        return this.doExport(definition);
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._namespace = "urn:liferay.com:liferay-workflow_" + this._version;
        this._schemaVersion = StringUtil.replace((String)this._version, (char)'.', (char)'_');
    }

    protected String doExport(Definition definition) throws KaleoDefinitionValidationException {
        try {
            Document document = SAXReaderUtil.createDocument();
            Element workflowDefinitionElement = document.addElement("workflow-definition");
            workflowDefinitionElement.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            workflowDefinitionElement.addAttribute("xsi:schemaLocation", StringBundler.concat((String[])new String[]{"urn:liferay.com:liferay-workflow_", this._version, " http://www.liferay.com/dtd/liferay-workflow-definition_", this._schemaVersion, ".xsd"}));
            workflowDefinitionElement.addNamespace("", "urn:liferay.com:liferay-workflow_" + this._version);
            Element nameElement = workflowDefinitionElement.addElement("name", this._namespace);
            nameElement.addText(definition.getName());
            if (Validator.isNotNull((String)definition.getDescription())) {
                Element descriptionElement = workflowDefinitionElement.addElement("description", this._namespace);
                descriptionElement.addText(definition.getDescription());
            }
            Element versionElement = workflowDefinitionElement.addElement("version", this._namespace);
            versionElement.addText(String.valueOf(definition.getVersion()));
            Collection nodes = definition.getNodes();
            for (Node node : nodes) {
                NodeExporter nodeExporter = this._nodeExporterRegistry.getNodeExporter(node.getNodeType());
                nodeExporter.exportNode(node, workflowDefinitionElement, this._namespace);
            }
            return document.formattedString();
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to export definition", (Throwable)ioException);
        }
    }
}

