/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export.builder;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.AddressRecipient;
import com.liferay.portal.workflow.kaleo.definition.AssigneesRecipient;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.AssignmentType;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.RecipientType;
import com.liferay.portal.workflow.kaleo.definition.ResourceActionAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleRecipient;
import com.liferay.portal.workflow.kaleo.definition.ScriptAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptRecipient;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.UserAssignment;
import com.liferay.portal.workflow.kaleo.definition.UserRecipient;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.NodeBuilder;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoNotification;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.service.KaleoActionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationRecipientLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerLocalService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseNodeBuilder<T extends Node>
implements NodeBuilder {
    @Reference
    protected KaleoActionLocalService kaleoActionLocalService;
    @Reference
    protected KaleoNotificationLocalService kaleoNotificationLocalService;
    @Reference
    protected KaleoNotificationRecipientLocalService kaleoNotificationRecipientLocalService;
    @Reference
    protected KaleoTaskAssignmentLocalService kaleoTaskAssignmentLocalService;
    @Reference
    protected KaleoTimerLocalService kaleoTimerLocalService;
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected UserLocalService userLocalService;

    @Override
    public T buildNode(KaleoNode kaleoNode) throws PortalException {
        T node = this.createNode(kaleoNode);
        Set<Action> actions = this.buildActions(kaleoNode.getCompanyId(), KaleoNode.class.getName(), kaleoNode.getKaleoNodeId());
        node.setActions(actions);
        node.setMetadata(kaleoNode.getMetadata());
        Set<Notification> notifications = this.buildNotifications(KaleoNode.class.getName(), kaleoNode.getKaleoNodeId());
        node.setNotifications(notifications);
        Set<Timer> timers = this.buildTimers(KaleoNode.class.getName(), kaleoNode.getKaleoNodeId());
        node.setTimers(timers);
        return node;
    }

    protected void addNotificationRecipients(KaleoNotification kaleoNotification, Notification notification) throws PortalException {
        List kaleoNotificationRecipients = this.kaleoNotificationRecipientLocalService.getKaleoNotificationRecipients(kaleoNotification.getKaleoNotificationId());
        for (KaleoNotificationRecipient kaleoNotificationRecipient : kaleoNotificationRecipients) {
            String recipientClassName = kaleoNotificationRecipient.getRecipientClassName();
            long recipientClassPK = kaleoNotificationRecipient.getRecipientClassPK();
            AddressRecipient recipient = null;
            if (recipientClassName.equals(RecipientType.ADDRESS.getValue())) {
                recipient = new AddressRecipient(kaleoNotificationRecipient.getAddress());
            } else if (recipientClassName.equals(RecipientType.ASSIGNEES.getValue())) {
                recipient = new AssigneesRecipient();
            } else if (recipientClassName.equals(RecipientType.ROLE.getValue())) {
                Role role = this.roleLocalService.fetchRole(recipientClassPK);
                recipient = new RoleRecipient(role.getName(), role.getTypeLabel());
            } else if (recipientClassName.equals(RecipientType.SCRIPT.getValue())) {
                recipient = new ScriptRecipient(kaleoNotificationRecipient.getRecipientScript(), kaleoNotificationRecipient.getRecipientScriptLanguage(), kaleoNotificationRecipient.getRecipientScriptContexts());
            } else if (recipientClassName.equals(RecipientType.USER.getValue())) {
                if (recipientClassPK > 0L) {
                    User user = this.userLocalService.getUser(recipientClassPK);
                    recipient = new UserRecipient(user.getUserId(), user.getScreenName(), user.getEmailAddress());
                } else {
                    recipient = new UserRecipient();
                }
            }
            recipient.setNotificationReceptionType(NotificationReceptionType.parse((String)kaleoNotificationRecipient.getNotificationReceptionType()));
            notification.addRecipients((Recipient)recipient);
        }
    }

    protected Set<Action> buildActions(long companyId, String kaleoClassName, long kaleoClassPK) throws KaleoDefinitionValidationException {
        List kaleoActions = this.kaleoActionLocalService.getKaleoActions(companyId, kaleoClassName, kaleoClassPK);
        HashSet<Action> actions = new HashSet<Action>();
        for (KaleoAction kaleoAction : kaleoActions) {
            Action action = new Action(kaleoAction.getName(), kaleoAction.getDescription(), kaleoAction.getExecutionType(), kaleoAction.getScript(), kaleoAction.getScriptLanguage(), kaleoAction.getScriptRequiredContexts(), kaleoAction.getPriority());
            actions.add(action);
        }
        return actions;
    }

    protected Set<Assignment> buildAssigments(String kaleoClassName, long kaleoClassPK) throws PortalException {
        List kaleoTaskAssignments = this.kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoClassName, kaleoClassPK);
        HashSet<Assignment> assignments = new HashSet<Assignment>();
        for (KaleoTaskAssignment kaleoTaskAssignment : kaleoTaskAssignments) {
            String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
            long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
            ScriptAssignment assignment = null;
            if (assigneeClassName.equals(AssignmentType.SCRIPT.name())) {
                assignment = new ScriptAssignment(kaleoTaskAssignment.getAssigneeScript(), kaleoTaskAssignment.getAssigneeScriptLanguage(), kaleoTaskAssignment.getAssigneeScriptRequiredContexts());
            } else if (assigneeClassName.equals(ResourceAction.class.getName())) {
                assignment = new ResourceActionAssignment(kaleoTaskAssignment.getAssigneeActionId());
            } else if (assigneeClassName.equals(Role.class.getName())) {
                Role role = this.roleLocalService.fetchRole(assigneeClassPK);
                assignment = new RoleAssignment(role.getRoleId(), role.getName(), role.getTypeLabel());
            } else if (assigneeClassName.equals(User.class.getName())) {
                if (assigneeClassPK == 0L) {
                    assignment = new UserAssignment();
                } else {
                    User user = this.userLocalService.getUser(assigneeClassPK);
                    assignment = new UserAssignment(user.getUserId(), user.getScreenName(), user.getEmailAddress());
                }
            }
            assignments.add((Assignment)assignment);
        }
        return assignments;
    }

    protected Set<Notification> buildNotifications(String kaleoClassName, long kaleoClassPK) throws PortalException {
        List kaleoNotifications = this.kaleoNotificationLocalService.getKaleoNotifications(kaleoClassName, kaleoClassPK);
        HashSet<Notification> notifications = new HashSet<Notification>();
        for (KaleoNotification kaleoNotification : kaleoNotifications) {
            String[] notificationTypeValues;
            Notification notification = new Notification(kaleoNotification.getName(), kaleoNotification.getDescription(), kaleoNotification.getExecutionType(), kaleoNotification.getTemplate(), kaleoNotification.getTemplateLanguage());
            notifications.add(notification);
            for (String notificationTypeValue : notificationTypeValues = StringUtil.split((String)kaleoNotification.getNotificationTypes(), (String)",")) {
                notification.addNotificationType(notificationTypeValue);
            }
            this.addNotificationRecipients(kaleoNotification, notification);
        }
        return notifications;
    }

    protected Set<Timer> buildTimers(String kaleoClassName, long kaleoClassPK) throws PortalException {
        List kaleoTimers = this.kaleoTimerLocalService.getKaleoTimers(kaleoClassName, kaleoClassPK);
        HashSet<Timer> timers = new HashSet<Timer>();
        for (KaleoTimer kaleoTimer : kaleoTimers) {
            Timer timer = new Timer(kaleoTimer.getName(), kaleoTimer.getDescription(), kaleoTimer.isBlocking());
            timers.add(timer);
            DelayDuration delayDuration = new DelayDuration(kaleoTimer.getDuration(), DurationScale.parse((String)kaleoTimer.getScale()));
            timer.setDelayDuration(delayDuration);
            String recurrenceScale = kaleoTimer.getRecurrenceScale();
            if (Validator.isNotNull((String)recurrenceScale)) {
                DelayDuration recurrenceDelayDuration = new DelayDuration(kaleoTimer.getRecurrenceDuration(), DurationScale.parse((String)recurrenceScale));
                timer.setRecurrence(recurrenceDelayDuration);
            }
            Set<Action> timerActions = this.buildActions(kaleoTimer.getCompanyId(), KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId());
            timer.setActions(timerActions);
            Set<Assignment> reassignments = this.buildAssigments(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId());
            timer.setReassignments(reassignments);
            Set<Notification> timerNotifications = this.buildNotifications(KaleoTimer.class.getName(), kaleoTimer.getKaleoTimerId());
            timer.setNotifications(timerNotifications);
        }
        return timers;
    }

    protected abstract T createNode(KaleoNode var1) throws PortalException;
}

