/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.export.builder.DefinitionBuilder;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.NodeBuilder;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.NodeBuilderRegistry;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DefinitionBuilder.class})
public class DefaultDefinitionBuilder
implements DefinitionBuilder {
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private NodeBuilderRegistry _nodeBuilderRegistry;

    public Definition buildDefinition(long kaleoDefinitionId) throws PortalException {
        KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.getKaleoDefinition(kaleoDefinitionId);
        return this.doBuildDefinition(this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoDefinition.getCompanyId(), kaleoDefinition.getName(), StringBundler.concat((Object[])new Object[]{kaleoDefinition.getVersion(), Character.valueOf('.'), 0})));
    }

    public Definition buildDefinition(long companyId, String name, int version) throws PortalException {
        return this.doBuildDefinition(this._kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(companyId, name, StringBundler.concat((Object[])new Object[]{version, Character.valueOf('.'), 0})));
    }

    protected Definition doBuildDefinition(KaleoDefinitionVersion kaleoDefinitionVersion) throws PortalException {
        Definition definition = new Definition(kaleoDefinitionVersion.getName(), kaleoDefinitionVersion.getDescription(), kaleoDefinitionVersion.getContent(), this._getVersion(kaleoDefinitionVersion.getVersion()));
        List kaleoNodes = this._kaleoNodeLocalService.getKaleoDefinitionVersionKaleoNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        for (KaleoNode kaleoNode : kaleoNodes) {
            NodeBuilder<Node> nodeBuilder = this._nodeBuilderRegistry.getNodeBuilder(kaleoNode.getType());
            Node node = nodeBuilder.buildNode(kaleoNode);
            definition.addNode(node);
        }
        List kaleoTransitions = this._kaleoTransitionLocalService.getKaleoDefinitionVersionKaleoTransitions(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        for (KaleoTransition kaleoTransition : kaleoTransitions) {
            String sourceNodeName = kaleoTransition.getSourceKaleoNodeName();
            Node sourceNode = definition.getNode(sourceNodeName);
            String targetNodeName = kaleoTransition.getTargetKaleoNodeName();
            Node targetNode = definition.getNode(targetNodeName);
            Transition transition = new Transition(kaleoTransition.getName(), sourceNode, targetNode, kaleoTransition.isDefaultTransition());
            sourceNode.addOutgoingTransition(transition);
            targetNode.addIncomingTransition(transition);
        }
        return definition;
    }

    private int _getVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        return versionParts[0];
    }
}

